/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.utils.Assert;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;

public final class Lists {
    private Lists() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(E ... es) {
        ArrayList<E> list = new ArrayList<E>();
        if (es != null) {
            for (E e : es) {
                if (e == null) continue;
                list.add(e);
            }
        }
        return list;
    }

    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    public static <T> List<ListData<T>> partition(List<T> list, int size) {
        return list instanceof RandomAccess ? new RandomAccessPartition<T>(list, size) : new Partition<T>(list, size);
    }

    static int hashCodeImpl(List<?> list) {
        int hashCode = 1;
        for (Object o : list) {
            hashCode = 31 * hashCode + (o == null ? 0 : o.hashCode());
            hashCode = ~(~hashCode);
        }
        return hashCode;
    }

    static <E> boolean addAllImpl(List<E> list, int index, Iterable<? extends E> elements) {
        boolean changed = false;
        ListIterator<E> listIterator = list.listIterator(index);
        for (E e : elements) {
            listIterator.add(e);
            changed = true;
        }
        return changed;
    }

    static <T> List<T> cast(Iterable<T> iterable) {
        return (List)iterable;
    }

    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        RandomAccessListWrapper(List<E> backingList) {
            super(backingList);
        }
    }

    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        AbstractListWrapper(List<E> backingList) {
            Assert.isTrue(backingList != null, "backingList is null");
            this.backingList = backingList;
        }

        @Override
        public void add(int index, E element) {
            this.backingList.add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.backingList.addAll(index, c);
        }

        @Override
        public E get(int index) {
            return this.backingList.get(index);
        }

        @Override
        public E remove(int index) {
            return this.backingList.remove(index);
        }

        @Override
        public E set(int index, E element) {
            return this.backingList.set(index, element);
        }

        @Override
        public boolean contains(Object o) {
            return this.backingList.contains(o);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int size) {
            super(list, size);
        }
    }

    private static class Partition<T>
    extends AbstractList<ListData<T>> {
        final List<T> list;
        final int size;
        volatile int psize;

        Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
            this.psize = (list.size() + size - 1) / size;
        }

        @Override
        public ListData<T> get(int index) {
            Assert.isTrue(index >= 0 && index < this.size(), " IndexOutOfBoundsException ");
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            List<T> ts = this.list.subList(start, end);
            return new ListData<T>(ts, index);
        }

        @Override
        public int size() {
            return this.psize;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    public static class ListData<T> {
        List<T> list;
        int partitionIndex;

        public ListData(List<T> list, int partitionIndex) {
            this.list = list;
            this.partitionIndex = partitionIndex;
        }

        public List<T> getList() {
            return this.list;
        }

        public int getPartitionIndex() {
            return this.partitionIndex;
        }
    }
}

