/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.BaseUnique;
import com.javaoffers.brief.modelhelper.core.ConvertProxy;
import com.javaoffers.brief.modelhelper.core.KeyGenerate;
import com.javaoffers.brief.modelhelper.core.UniqueKeyGenerate;
import com.javaoffers.brief.modelhelper.core.gkey.VoidKey;
import com.javaoffers.brief.modelhelper.exception.ParseModelException;
import com.javaoffers.brief.modelhelper.utils.Getter;
import com.javaoffers.brief.modelhelper.utils.LambdaCreateUtils;
import com.javaoffers.brief.modelhelper.utils.Newc;
import com.javaoffers.brief.modelhelper.utils.Setter;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ModelFieldInfo {
    private boolean isModelClass;
    private Class modelClass;
    private Class fieldGenericClass;
    private Class fieldType;
    private TableInfo tableInfo;
    private String tableName;
    private Field field;
    private Setter setter;
    private Getter getter;
    private String fieldName;
    private String aliasName;
    private boolean isUniqueField;
    private boolean fieldTypeIsAbstract;
    private Newc newc;
    private ConvertProxy convertProxy;
    private boolean isAtoGkey;
    private UniqueKeyGenerate uniqueKeyGenerate;

    private ModelFieldInfo() {
    }

    public ModelFieldInfo(Field field, Class modelClass) {
        this.field = field;
        this.modelClass = modelClass;
        this.init();
    }

    private void init() {
        this.field.setAccessible(true);
        try {
            this.isModelClass = Utils.isBaseModel(this.field);
            this.setter = LambdaCreateUtils.createSetter(this.field);
            this.getter = LambdaCreateUtils.createGetter(this.field);
            this.fieldName = this.field.getName();
            this.tableInfo = TableHelper.getTableInfo(this.modelClass);
            this.tableName = this.tableInfo.getTableName();
            this.aliasName = Utils.getSpecialColName(this.tableName, this.tableInfo.getDbType(), this.fieldName);
            BaseUnique baseUnique = this.field.getDeclaredAnnotation(BaseUnique.class);
            this.isUniqueField = baseUnique != null;
            this.fieldGenericClass = Utils.getGenericityClass(this.field);
            this.fieldType = this.field.getType();
            this.fieldTypeIsAbstract = this.fieldType.isInterface();
            if (this.fieldTypeIsAbstract) {
                if (List.class.isAssignableFrom(this.fieldType)) {
                    this.newc = ArrayList::new;
                } else if (Set.class.isAssignableFrom(this.fieldType)) {
                    this.newc = HashSet::new;
                } else if (Collection.class.isAssignableFrom(this.fieldType)) {
                    this.newc = ArrayList::new;
                }
            } else if (Collection.class.isAssignableFrom(this.fieldType)) {
                this.newc = LambdaCreateUtils.createConstructor(this.fieldType);
            }
            if (this.isUniqueField) {
                Class<? extends UniqueKeyGenerate> keyGenerateClass = baseUnique.keyGenerateClass();
                KeyGenerate keyGenerate = baseUnique.keyGenerate();
                if (keyGenerateClass != VoidKey.class) {
                    this.uniqueKeyGenerate = keyGenerateClass.newInstance();
                } else if (keyGenerate != KeyGenerate.VOID_KEY) {
                    Class gkeyClass = keyGenerate.getGkeyClass();
                    this.uniqueKeyGenerate = (UniqueKeyGenerate)gkeyClass.newInstance();
                }
                this.isAtoGkey = this.uniqueKeyGenerate != null;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ParseModelException(e.getMessage());
        }
    }

    public ModelFieldInfo cloneFieldNameAsAliasName() {
        ModelFieldInfo modelFieldInfo = new ModelFieldInfo();
        modelFieldInfo.isModelClass = this.isModelClass;
        modelFieldInfo.modelClass = this.modelClass;
        modelFieldInfo.fieldGenericClass = this.fieldGenericClass;
        modelFieldInfo.fieldType = this.fieldType;
        modelFieldInfo.tableInfo = this.tableInfo;
        modelFieldInfo.tableName = this.tableName;
        modelFieldInfo.field = this.field;
        modelFieldInfo.setter = this.setter;
        modelFieldInfo.getter = this.getter;
        modelFieldInfo.fieldName = this.fieldName;
        modelFieldInfo.aliasName = this.fieldName;
        modelFieldInfo.isUniqueField = this.isUniqueField;
        modelFieldInfo.fieldTypeIsAbstract = this.fieldTypeIsAbstract;
        modelFieldInfo.newc = this.newc;
        return modelFieldInfo;
    }

    public Class getModelClassOfField() {
        if (!this.isModelClass) {
            return null;
        }
        return this.fieldGenericClass;
    }

    public boolean isModelClass() {
        return this.isModelClass;
    }

    public Field getField() {
        return this.field;
    }

    public Setter getSetter() {
        return this.setter;
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAliasName() {
        return this.aliasName;
    }

    public boolean isUniqueField() {
        return this.isUniqueField;
    }

    public Class getFieldGenericClass() {
        return this.fieldGenericClass;
    }

    public Getter getGetter() {
        return this.getter;
    }

    public boolean isAbstractFieldType() {
        return this.fieldTypeIsAbstract;
    }

    public Object getNewc() {
        return this.newc.newc();
    }

    public ConvertProxy getConvertProxy() {
        return this.convertProxy;
    }

    public void setConvertProxy(ConvertProxy convertProxy) {
        if (convertProxy != null) {
            this.convertProxy = convertProxy;
        }
    }

    public boolean isAtoGkey() {
        return this.isAtoGkey;
    }

    public UniqueKeyGenerate getUniqueKeyGenerate() {
        return this.uniqueKeyGenerate;
    }
}

