/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.exception.ParseModelException;
import com.javaoffers.brief.modelhelper.utils.LambdaCreateUtils;
import com.javaoffers.brief.modelhelper.utils.ModelFieldInfo;
import com.javaoffers.brief.modelhelper.utils.ModelFieldInfoPosition;
import com.javaoffers.brief.modelhelper.utils.Newc;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ModelInfo<T> {
    Class<T> modelClass;
    Newc<T> constructor;
    Map<String, ModelFieldInfo> onesColNameMap = new HashMap<String, ModelFieldInfo>();
    List<ModelFieldInfo> onesModels = new ArrayList<ModelFieldInfo>();
    Map<String, ModelFieldInfo> uniqueColNameMap = new HashMap<String, ModelFieldInfo>();
    List<ModelFieldInfo> uniqueModels = new ArrayList<ModelFieldInfo>();
    List<ModelFieldInfo> arraysModels = new ArrayList<ModelFieldInfo>();
    List<ModelFieldInfo> listModels = new ArrayList<ModelFieldInfo>();
    List<ModelFieldInfo> setModels = new ArrayList<ModelFieldInfo>();
    List<ModelFieldInfo> gkeyUniqueModels = new ArrayList<ModelFieldInfo>();

    public ModelInfo(Class<T> modelClass) {
        this.modelClass = modelClass;
        ArrayList<ModelFieldInfo> ones = new ArrayList<ModelFieldInfo>();
        ArrayList<ModelFieldInfo> arrays = new ArrayList<ModelFieldInfo>();
        ArrayList<ModelFieldInfo> list = new ArrayList<ModelFieldInfo>();
        ArrayList<ModelFieldInfo> set = new ArrayList<ModelFieldInfo>();
        Field[] colFs = Utils.getFields(modelClass).toArray(new Field[0]);
        for (Field fd : colFs) {
            if (fd.getType().isArray()) {
                arrays.add(new ModelFieldInfo(fd, this.modelClass));
                continue;
            }
            if (List.class.isAssignableFrom(fd.getType())) {
                list.add(new ModelFieldInfo(fd, this.modelClass));
                continue;
            }
            if (Set.class.isAssignableFrom(fd.getType())) {
                set.add(new ModelFieldInfo(fd, this.modelClass));
                continue;
            }
            ones.add(new ModelFieldInfo(fd, this.modelClass));
        }
        try {
            for (ModelFieldInfo modelFieldInfo : ones) {
                ModelFieldInfo fieldNameAsAliasNameFieldInfo = modelFieldInfo.cloneFieldNameAsAliasName();
                if (modelFieldInfo.isModelClass()) {
                    this.addModel(this.onesModels, modelFieldInfo);
                    if (!modelFieldInfo.isUniqueField()) continue;
                    this.addModel(this.uniqueModels, modelFieldInfo);
                    continue;
                }
                this.put(this.onesColNameMap, modelFieldInfo, fieldNameAsAliasNameFieldInfo);
                if (modelFieldInfo.isUniqueField()) {
                    this.put(this.uniqueColNameMap, modelFieldInfo, fieldNameAsAliasNameFieldInfo);
                }
                if (!modelFieldInfo.isAtoGkey()) continue;
                this.gkeyUniqueModels.add(modelFieldInfo);
            }
            this.addModel(this.arraysModels, arrays);
            this.addModel(this.listModels, list);
            this.addModel(this.setModels, set);
            this.constructor = LambdaCreateUtils.createConstructor(modelClass);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new ParseModelException(e.getMessage());
        }
    }

    public void put(Map<String, ModelFieldInfo> map, ModelFieldInfo ... modelFieldInfos) {
        for (ModelFieldInfo modelFieldInfo : modelFieldInfos) {
            map.put(modelFieldInfo.getAliasName(), modelFieldInfo);
        }
    }

    public void addModel(List<ModelFieldInfo> modes, ArrayList<ModelFieldInfo> listTmp) {
        for (ModelFieldInfo modelFieldInfo : listTmp) {
            if (!modelFieldInfo.isModelClass()) continue;
            modes.add(modelFieldInfo);
        }
    }

    public void addModel(List<ModelFieldInfo> modes, ModelFieldInfo ... modelFieldInfos) {
        for (ModelFieldInfo modelFieldInfo : modelFieldInfos) {
            if (!modelFieldInfo.isModelClass()) continue;
            modes.add(modelFieldInfo);
        }
    }

    public T newC() {
        return this.constructor.newc();
    }

    public Class<T> getModelClass() {
        return this.modelClass;
    }

    public Newc<T> getConstructor() {
        return this.constructor;
    }

    public List<ModelFieldInfoPosition> getOnesColWithOneModel(List<String> colNames) {
        ArrayList<ModelFieldInfoPosition> ones = new ArrayList<ModelFieldInfoPosition>();
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = colNames.get(i);
            ModelFieldInfo modelFieldInfo2 = this.onesColNameMap.get(colName);
            if (modelFieldInfo2 == null) continue;
            ones.add(new ModelFieldInfoPosition(i, modelFieldInfo2));
        }
        List oneModelTmp = this.onesModels.stream().filter((? super T oneFieldModel) -> {
            ModelInfo modelInfo = TableHelper.getModelInfo(oneFieldModel.getModelClassOfField());
            return modelInfo.getOnesColWithOneModel(colNames).size() > 0;
        }).map(modelFieldInfo -> new ModelFieldInfoPosition(-1, (ModelFieldInfo)modelFieldInfo)).collect(Collectors.toList());
        ones.addAll(oneModelTmp);
        return ones;
    }

    public List<ModelFieldInfoPosition> getOnesCol(List<String> colNames) {
        ArrayList<ModelFieldInfoPosition> ones = new ArrayList<ModelFieldInfoPosition>();
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = colNames.get(i);
            ModelFieldInfo modelFieldInfo = this.onesColNameMap.get(colName);
            if (modelFieldInfo == null || modelFieldInfo.isModelClass()) continue;
            ones.add(new ModelFieldInfoPosition(i, modelFieldInfo));
        }
        return ones;
    }

    public List<ModelFieldInfo> getArrays(List<String> colNames) {
        return this.arraysModels.stream().filter(this.filter(colNames)).collect(Collectors.toList());
    }

    public List<ModelFieldInfo> getList(List<String> colNames) {
        return this.listModels.stream().filter(this.filter(colNames)).collect(Collectors.toList());
    }

    public List<ModelFieldInfo> getSet(List<String> colNames) {
        return this.setModels.stream().filter(this.filter(colNames)).collect(Collectors.toList());
    }

    public List<ModelFieldInfoPosition> getUniqueCol(List<String> colNames) {
        ArrayList<ModelFieldInfoPosition> unique = new ArrayList<ModelFieldInfoPosition>();
        for (int i = 0; i < colNames.size(); ++i) {
            String colName = colNames.get(i);
            ModelFieldInfo modelFieldInfo = this.uniqueColNameMap.get(colName);
            if (modelFieldInfo == null) continue;
            unique.add(new ModelFieldInfoPosition(i, modelFieldInfo));
        }
        return unique;
    }

    public List<ModelFieldInfo> getGkeyUniqueModels() {
        return this.gkeyUniqueModels;
    }

    private Predicate<ModelFieldInfo> filter(List<String> colNames) {
        return modelFieldInfo -> {
            ModelInfo modelInfo = TableHelper.getModelInfo(modelFieldInfo.getModelClassOfField());
            return modelInfo.getOnesCol(colNames).size() > 0;
        };
    }
}

