/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.exception.NewInstanceException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class ReflectionUtils {
    static Reflections reflections = new Reflections(new Object[]{"com.javaoffers.brief.modelhelper", Arrays.asList(new SubTypesScanner(false), new MethodParameterNamesScanner(), new MethodAnnotationsScanner(), new TypeAnnotationsScanner())});

    public static <T> Set<Class<? extends T>> getChilds(Class<T> c) {
        Set subTypesOf = reflections.getSubTypesOf(c);
        return new HashSet<Class<? extends T>>(subTypesOf);
    }

    public static <T> Set<T> getChildInstance(Class<T> c) {
        Set<Class<T>> subTypesOf = ReflectionUtils.getChildClassWithOutAbstract(c);
        HashSet<T> instanceSet = new HashSet<T>();
        for (Class<T> clazz : subTypesOf) {
            try {
                Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                T t = constructor.newInstance(new Object[0]);
                instanceSet.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NewInstanceException(e.getMessage());
            }
        }
        return instanceSet;
    }

    public static <T> Set<Class<T>> getChildClassWithOutAbstract(Class<T> c) {
        Set subTypesOf = reflections.getSubTypesOf(c);
        HashSet<Class<T>> instanceSet = new HashSet<Class<T>>();
        for (Class clazz : subTypesOf) {
            try {
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    instanceSet.addAll(ReflectionUtils.getChildClassWithOutAbstract(clazz));
                    continue;
                }
                instanceSet.add(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NewInstanceException(e.getMessage());
            }
        }
        return instanceSet;
    }
}

