/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.utils.CommonExecutor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class SoftCache<T, V>
implements Runnable {
    private static int limitMi = 2048;
    private ReferenceQueue<V> referenceQueue;
    private volatile Map<T, SoftData<T, V>> cache = new ConcurrentHashMap<T, SoftData<T, V>>(256);

    public static <T, V> SoftCache<T, V> getInstance() {
        SoftCache<T, V> softCache = new SoftCache<T, V>();
        softCache.referenceQueue = new ReferenceQueue();
        CommonExecutor.oneFixedScheduledThreadPool.scheduleWithFixedDelay(softCache, 60L, 60L, TimeUnit.SECONDS);
        return softCache;
    }

    public void put(T key, V value) {
        if (key == null || value == null) {
            return;
        }
        SoftData<T, V> softData = new SoftData<T, V>(key, value, this.referenceQueue);
        this.cache.put(key, softData);
    }

    public V get(T key) {
        if (key == null) {
            return null;
        }
        SoftData<T, V> softData = this.cache.get(key);
        if (softData != null) {
            Object value = softData.get();
            if (value != null) {
                return (V)value;
            }
            this.cache.remove(key);
        }
        return null;
    }

    @Override
    public void run() {
        try {
            long mk = Runtime.getRuntime().freeMemory() >> 20;
            AtomicBoolean statue = new AtomicBoolean(false);
            if ((long)limitMi < mk) {
                ConcurrentHashMap newCache = new ConcurrentHashMap(256);
                this.cache.forEach((key, value) -> {
                    if (value.get() != null) {
                        newCache.put((Object)key, (SoftData)value);
                    } else {
                        statue.set(true);
                    }
                });
                if (statue.get()) {
                    this.cache = newCache;
                    this.referenceQueue = new ReferenceQueue();
                }
            } else {
                this.cache.forEach((key, value) -> {
                    if (value.get() == null) {
                        this.cache.remove(key);
                        statue.set(true);
                    }
                });
                if (statue.get()) {
                    this.referenceQueue = new ReferenceQueue();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private SoftCache() {
    }

    static class SoftData<T, V>
    extends SoftReference<V> {
        T key;

        public SoftData(T key, V value, ReferenceQueue<V> referenceQueue) {
            super(value, referenceQueue);
            this.key = key;
        }
    }
}

