/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.BaseModel;
import com.javaoffers.brief.modelhelper.anno.BaseUnique;
import com.javaoffers.brief.modelhelper.anno.NoneCol;
import com.javaoffers.brief.modelhelper.anno.fun.parse.FunAnnoParser;
import com.javaoffers.brief.modelhelper.anno.fun.parse.ParseSqlFunResult;
import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.exception.BaseException;
import com.javaoffers.brief.modelhelper.exception.FindColException;
import com.javaoffers.brief.modelhelper.exception.ParseTableException;
import com.javaoffers.brief.modelhelper.filter.JqlFunFilter;
import com.javaoffers.brief.modelhelper.filter.impl.AsSqlFunFilterImpl;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConstructorFun;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.DeriveProcessFire;
import com.javaoffers.brief.modelhelper.utils.ModelInfo;
import com.javaoffers.brief.modelhelper.utils.SqlColInfo;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TableHelper
implements BriefContextAware {
    private static final Map<Class, ModelInfo> modelInfoMap = new ConcurrentHashMap<Class, ModelInfo>();
    private static final Map<Class, TableInfo> tableInfoMap = new ConcurrentHashMap<Class, TableInfo>();
    private static final Map<Class, List<Condition>> colAllMap = new ConcurrentHashMap<Class, List<Condition>>();
    private static final Map<String, Class> modelClass = new ConcurrentHashMap<String, Class>();
    private static final Map<Class, Boolean> modelIsParse = new ConcurrentHashMap<Class, Boolean>();
    private static final List<JqlFunFilter> TABLE_HELPER_FILTER = new ArrayList<JqlFunFilter>();
    private static BriefContext briefContext;

    public static List<String> getColAllForSelect(Class<?> modelClss) {
        LinkedList<String> colAll = new LinkedList<String>();
        TableInfo tableInfo = tableInfoMap.get(modelClss);
        String tableName = tableInfo.getTableName();
        tableInfo.getFieldNameColNameOfModel().forEach((fieldName, colName) -> {
            if (tableInfo.isSqlFun((String)colName)) {
                if (!tableInfo.colNameIsExcludeColAll((String)colName)) {
                    colAll.add(colName + " as " + tableName + "__" + fieldName);
                }
            } else if (!tableInfo.fieldNameIsExcludeColAll((String)fieldName)) {
                colAll.add(tableName + "." + colName + " as " + tableName + "__" + fieldName);
            }
        });
        return colAll;
    }

    public static <T extends Condition> List<T> getColAllForSelect(Class<?> modelClss, Function<String, T> createCondition) {
        List<Condition> conditions = colAllMap.get(modelClss);
        if (conditions == null) {
            List<String> colAllForSelect = TableHelper.getColAllForSelect(modelClss);
            conditions = new ArrayList<Condition>();
            for (String colName : colAllForSelect) {
                conditions.add((Condition)createCondition.apply(colName));
            }
            conditions = Collections.unmodifiableList(conditions);
            colAllMap.putIfAbsent(modelClss, conditions);
        }
        return conditions;
    }

    public static List<SqlColInfo> getColAllAndAliasNameOnly(Class<?> modelClss) {
        LinkedList<SqlColInfo> colAll = new LinkedList<SqlColInfo>();
        TableInfo tableInfo = tableInfoMap.get(modelClss);
        tableInfo.getFieldNameColNameOfModel().forEach((colName, fieldName) -> colAll.add(new SqlColInfo(tableInfo.getTableName(), (String)colName, (String)fieldName, tableInfo.isSqlFun((String)colName))));
        return colAll;
    }

    public static Map<String, List<Field>> getColAllAndFieldOnly(Class<?> modelClss) {
        TableInfo tableInfo = tableInfoMap.get(modelClss);
        Map<String, List<Field>> colNameOfModelField = tableInfo.getColNameAndFieldOfModel();
        return colNameOfModelField;
    }

    public static Map<String, List<Field>> getOriginalColAllAndFieldOnly(Class<?> modelClss) {
        TableInfo tableInfo = tableInfoMap.get(modelClss);
        Map<String, List<Field>> colNameOfModelField = tableInfo.getOriginalColNameOfModelField();
        return colNameOfModelField;
    }

    public static String getColNameForSelect(GetterFun myFun) {
        SqlColInfo sqlColInfo = TableHelper.getSqlColInfo(myFun);
        String tableName = sqlColInfo.getTableName();
        String colName = sqlColInfo.getColNameNotBlank();
        String aliasName = sqlColInfo.getAliasName();
        colName = sqlColInfo.isSqlFun() ? colName + " as " + tableName + "__" + aliasName : tableName + "." + colName + " as " + tableName + "__" + aliasName;
        return colName;
    }

    public static Pair<String, String> getSelectAggrColStatement(GetterFun myFun) {
        SqlColInfo sqlColInfo = TableHelper.getSqlColInfo(myFun);
        String tableName = sqlColInfo.getTableName();
        String colName = sqlColInfo.getColNameNotBlank();
        String aliasName = tableName + "__" + sqlColInfo.getAliasName();
        Pair pair = null;
        pair = sqlColInfo.isSqlFun() ? Pair.of((Object)colName, (Object)aliasName) : Pair.of((Object)(tableName + "." + colName), (Object)aliasName);
        return pair;
    }

    public static String getColNameNotAs(GetterFun myFun) {
        SqlColInfo sqlColInfo = TableHelper.getSqlColInfo(myFun);
        String colName = sqlColInfo.getColNameNotBlank();
        String tableName = sqlColInfo.getTableName();
        if (!sqlColInfo.isSqlFun()) {
            colName = tableName + "." + colName;
        }
        return colName;
    }

    public static SqlColInfo getSqlColInfo(GetterFun myFun) {
        String methodName = "";
        try {
            Method writeReplace = myFun.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object sl = writeReplace.invoke((Object)myFun, new Object[0]);
            SerializedLambda serializedLambda = (SerializedLambda)sl;
            methodName = serializedLambda.getImplMethodName();
            String implClass = serializedLambda.getImplClass();
            TableInfo tableInfo = tableInfoMap.get(modelClass.get(implClass));
            Map<String, String> colNameOfGetter = tableInfo.getMethodNameMappingFieldNameOfGetter();
            colNameOfGetter.computeIfAbsent(methodName, k -> {
                k = k.startsWith("get") ? k.substring(3) : (k.startsWith("is") ? k.substring(2) : k);
                k = k.substring(0, 1).toLowerCase() + k.substring(1);
                return k;
            });
            String fieldName = colNameOfGetter.get(methodName);
            String colName = tableInfo.getFieldNameColNameOfModel().get(fieldName);
            return new SqlColInfo(tableInfo.getTableName(), colName, fieldName, tableInfo.isSqlFun(colName));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FindColException("Error parsing sql field \uff1a " + myFun.toString());
        }
    }

    public static Pair<String, String> getColNameAndAliasName(GetterFun myFun) {
        SqlColInfo selectColInfo = TableHelper.getSqlColInfo(myFun);
        String tableName = selectColInfo.getTableName();
        String colName = selectColInfo.getColName();
        String aliasName = selectColInfo.getAliasName();
        if (!selectColInfo.isSqlFun()) {
            colName = tableName + "." + colName;
        }
        return Pair.of((Object)colName, (Object)aliasName);
    }

    public static String getColNameOnly(GetterFun myFun) {
        SqlColInfo sqlColInfo = TableHelper.getSqlColInfo(myFun);
        return sqlColInfo.getColNameNotBlank();
    }

    public static void parseTableInfo(Class clazz, Connection connection) {
        String name = clazz.getName().replaceAll("\\.", "/");
        modelClass.computeIfAbsent(name, k -> {
            try {
                TableHelper.parseModelClass(clazz, connection);
                return clazz;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseModelClass(Class<?> modelClazz, Connection connection) {
        Boolean isParse = modelIsParse.getOrDefault(modelClazz, false);
        if (!isParse.booleanValue()) {
            Class<?> clazz = modelClazz;
            synchronized (clazz) {
                isParse = modelIsParse.getOrDefault(modelClazz, false);
                if (!isParse.booleanValue()) {
                    BaseModel table = modelClazz.getDeclaredAnnotation(BaseModel.class);
                    Assert.isTrue(table != null, "please use @BaseModel on class " + modelClazz.getName());
                    TableHelper.parseTableInfo(modelClazz, connection, table);
                    TableHelper.parseModelInfo(modelClazz);
                }
            }
        }
    }

    private static void parseModelInfo(Class<?> modelClazz) {
        modelInfoMap.put(modelClazz, new ModelInfo(modelClazz));
    }

    private static void parseTableInfo(Class<?> modelClazz, Connection connection, BaseModel table) {
        String tableName = table.value();
        if (StringUtils.isBlank((CharSequence)tableName)) {
            String simpleName = modelClazz.getSimpleName();
            tableName = Utils.conLine(simpleName);
        }
        try {
            TableInfo tableInfo = new TableInfo(tableName).setModelClass(modelClazz);
            tableInfo.setBaseModel(table);
            briefContext.getTableInfoParser().parseTableInfo(connection, tableInfo);
            tableInfoMap.put(modelClazz, tableInfo);
            Field[] colFs = Utils.getFields(modelClazz).toArray(new Field[0]);
            boolean uniqueStatus = false;
            for (Field colF : colFs) {
                if (colF.getDeclaredAnnotation(NoneCol.class) != null) continue;
                String colName = Utils.conLine(colF.getName());
                BaseUnique baseUnique = colF.getDeclaredAnnotation(BaseUnique.class);
                if (baseUnique != null) {
                    uniqueStatus = true;
                    if (StringUtils.isNotBlank((CharSequence)baseUnique.value())) {
                        colName = baseUnique.value();
                    }
                }
                ParseSqlFunResult parseColName = FunAnnoParser.parse(tableInfo, modelClazz, colF, colName);
                String fieldName = colF.getName();
                boolean isFunSql = false;
                boolean isExcludeColAll = false;
                if (parseColName != null) {
                    isExcludeColAll = parseColName.isExcludeColAll();
                    colName = parseColName.getSqlFun();
                    if (isExcludeColAll) {
                        tableInfo.putFieldNameExcludeColAll(fieldName, isExcludeColAll);
                    }
                    isFunSql = parseColName.isFun();
                    tableInfo.putSqlFun(colName, isFunSql);
                    tableInfo.putColNameExcludeColAll(colName, isExcludeColAll);
                } else if (!tableInfo.getColNames().containsKey(colName)) continue;
                if (!isFunSql) {
                    for (JqlFunFilter fieldFilter : TABLE_HELPER_FILTER) {
                        if (!((Boolean)fieldFilter.filter(colF)).booleanValue()) continue;
                        colName = tableName + "." + colName;
                        isFunSql = true;
                        tableInfo.putSqlFun(colName, true);
                        break;
                    }
                }
                DeriveProcessFire.processDerive(tableInfo, colF, colName);
                tableInfo.putFieldNameColNameOfModel(fieldName, colName);
                tableInfo.putColNameAndFieldOfModel(colName, colF);
                tableInfo.putFieldNameAndField(fieldName, colF);
                if (isFunSql || isExcludeColAll || !tableInfo.getColNames().containsKey(colName)) continue;
                tableInfo.putOriginalColNameAndFieldOfModelField(colName, colF);
            }
            Assert.isTrue(uniqueStatus, "Please declare @BaseUnique field in the model " + modelClazz.getName());
            tableInfo.unmodifiable();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseTableException(e.getMessage(), e);
        }
        modelIsParse.put(modelClazz, true);
    }

    public static <M2> Class<M2> getClassFromConstructorFun(ConstructorFun<M2> constructorFun) {
        String implClass = "";
        try {
            Method method = constructorFun.getClass().getDeclaredMethods()[0];
            method.setAccessible(true);
            Object sl = method.invoke(constructorFun, new Object[0]);
            String lamdaName = sl.getClass().getName();
            implClass = lamdaName.replaceAll("\\.", "/");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(e.getMessage());
        }
        return modelClass.get(implClass);
    }

    public static <M2> Class<M2> getClassFromConstructorFunForJoin(ConstructorFun<M2> constructorFun, DataSource dataSource) {
        Class aClass;
        block15: {
            String implClass = "";
            Class<?> clazz = null;
            aClass = null;
            Connection connection = null;
            try {
                try {
                    clazz = constructorFun.f().getClass();
                    String lamdaName = clazz.getName();
                    implClass = lamdaName.replaceAll("\\.", "/");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                aClass = modelClass.get(implClass);
                if (aClass != null) break block15;
                try {
                    connection = dataSource.getConnection();
                    TableHelper.parseTableInfo(clazz, connection);
                    aClass = modelClass.get(implClass);
                    if (aClass == null) {
                        throw new ParseTableException("There was an error parsing the table, the table may not exist");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ParseTableException(e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ParseTableException(e.getMessage());
            }
            finally {
                try {
                    if (connection != null && !connection.isClosed()) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    throw new ParseTableException(e.getMessage());
                }
            }
        }
        return aClass;
    }

    public static <M2> String getTableName(Class<M2> m2c) {
        return TableHelper.getTableInfo(m2c).getTableName();
    }

    public static TableInfo getTableInfo(Class<?> m2c) {
        TableInfo tableInfo = tableInfoMap.get(m2c);
        return tableInfo;
    }

    public static <T> ModelInfo<T> getModelInfo(Class<T> m2c) {
        return modelInfoMap.get(m2c);
    }

    @Override
    public void setBriefContext(BriefContext briefContext) {
        TableHelper.briefContext = briefContext;
    }

    static {
        TABLE_HELPER_FILTER.add(new AsSqlFunFilterImpl());
    }
}

