/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.BaseModel;
import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveFlag;
import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveInfo;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.ColNameAnnoInfo;
import com.javaoffers.brief.modelhelper.utils.ColumnInfo;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.FieldNameAnnoInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TableInfo {
    private Class<?> modelClazz;
    private DBType dbType;
    private String tableName;
    private BaseModel baseModel;
    private Map<String, ColumnInfo> primaryColNames = new LinkedHashMap<String, ColumnInfo>();
    private Map<String, ColumnInfo> colNames = new LinkedHashMap<String, ColumnInfo>();
    private Set<ColumnInfo> columnInfos = new LinkedHashSet<ColumnInfo>();
    private Map<String, List<Field>> originalColNameOfModelField = new LinkedHashMap<String, List<Field>>();
    private Map<String, Field> fieldNameAndFields = new HashMap<String, Field>();
    private Map<String, String> fieldNameMappingcolNameOfModel = new LinkedHashMap<String, String>();
    private Map<String, List<Field>> colNameMappingModelFields = new LinkedHashMap<String, List<Field>>();
    private Map<String, String> colNameOfGetter = new ConcurrentHashMap<String, String>();
    private Map<String, ColNameAnnoInfo> colNameAnnoInfos = new HashMap<String, ColNameAnnoInfo>();
    private Map<String, FieldNameAnnoInfo> fieldNameAnnoInfos = new HashMap<String, FieldNameAnnoInfo>();
    private Map<DeriveFlag, DeriveInfo> deriveColName = new HashMap<DeriveFlag, DeriveInfo>();

    public DBType getDbType() {
        return this.dbType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Map<String, ColumnInfo> getColNames() {
        return this.colNames;
    }

    public void putColNames(String colName, ColumnInfo columnInfo) {
        this.colNames.put(colName, columnInfo);
    }

    public Set<ColumnInfo> getColumnInfos() {
        return this.columnInfos;
    }

    public TableInfo(String tableName) {
        this.tableName = tableName;
    }

    public BaseModel getBaseModel() {
        return this.baseModel;
    }

    public void setBaseModel(BaseModel baseModel) {
        this.baseModel = baseModel;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public TableInfo setModelClass(Class clazz) {
        this.modelClazz = clazz;
        return this;
    }

    public Class<?> getModelClass() {
        return this.modelClazz;
    }

    public Map<String, String> getFieldNameColNameOfModel() {
        return this.fieldNameMappingcolNameOfModel;
    }

    void putFieldNameColNameOfModel(String fieldName, String colName) {
        this.fieldNameMappingcolNameOfModel.put(fieldName, colName);
    }

    Map<String, String> getMethodNameMappingFieldNameOfGetter() {
        return this.colNameOfGetter;
    }

    public Map<String, List<Field>> getColNameAndFieldOfModel() {
        return this.colNameMappingModelFields;
    }

    private ColumnInfo getColumnInfo(String colName) {
        ColumnInfo columnInfo = this.getColNames().get(colName);
        Assert.isTrue(columnInfo != null, "the " + colName + "col name is empty");
        return columnInfo;
    }

    public Map<String, ColumnInfo> getPrimaryColNames() {
        return this.primaryColNames;
    }

    public Map<String, List<Field>> getOriginalColNameOfModelField() {
        return this.originalColNameOfModelField;
    }

    public boolean isSqlFun(String colName) {
        ColNameAnnoInfo colNameAnnoInfo = this.getColNameAnnoInfoNotCreate(colName);
        return colNameAnnoInfo.isSqlFun();
    }

    public boolean colNameIsExcludeColAll(String colName) {
        ColNameAnnoInfo colNameAnnoInfoNotCreate = this.getColNameAnnoInfoNotCreate(colName);
        return colNameAnnoInfoNotCreate.isExcludeColAll();
    }

    public Map<String, Field> getFieldNameAndField() {
        return this.fieldNameAndFields;
    }

    public boolean fieldNameIsExcludeColAll(String fieldName) {
        FieldNameAnnoInfo fieldNameAnnoInfo = this.getFieldNameAnnoInfoNotCreate(fieldName);
        return fieldNameAnnoInfo.isExcludeColAll();
    }

    private FieldNameAnnoInfo getFieldNameAnnoInfoNotCreate(String fieldName) {
        return this.fieldNameAnnoInfos.getOrDefault(fieldName, new FieldNameAnnoInfo());
    }

    void putFieldNameExcludeColAll(String fieldName, boolean isExcludeColAll) {
        FieldNameAnnoInfo fieldNameAnnoInfo = this.getFieldNameAnnoInfoOrCreate(fieldName);
        fieldNameAnnoInfo.setExcludeColAll(isExcludeColAll);
    }

    FieldNameAnnoInfo getFieldNameAnnoInfoOrCreate(String fieldName) {
        FieldNameAnnoInfo fieldNameAnnoInfo = this.fieldNameAnnoInfos.get(fieldName);
        if (fieldNameAnnoInfo == null) {
            fieldNameAnnoInfo = new FieldNameAnnoInfo();
            fieldNameAnnoInfo.setFieldName(fieldName);
        }
        this.fieldNameAnnoInfos.put(fieldName, fieldNameAnnoInfo);
        return fieldNameAnnoInfo;
    }

    Map<String, List<Field>> putColNameAndFieldOfModel(String colName, Field field) {
        List<Field> fields = this.colNameMappingModelFields.get(colName);
        if (fields == null) {
            fields = new LinkedList<Field>();
            this.colNameMappingModelFields.put(colName, fields);
        }
        fields.add(field);
        return this.colNameMappingModelFields;
    }

    ColNameAnnoInfo getColNameAnnoInfoOrCreate(String colName) {
        ColNameAnnoInfo colNameAnnoInfo = this.colNameAnnoInfos.get(colName);
        if (colNameAnnoInfo == null) {
            colNameAnnoInfo = new ColNameAnnoInfo();
            colNameAnnoInfo.setColName(colName);
        }
        this.colNameAnnoInfos.put(colName, colNameAnnoInfo);
        return colNameAnnoInfo;
    }

    ColNameAnnoInfo getColNameAnnoInfoNotCreate(String colName) {
        return this.colNameAnnoInfos.getOrDefault(colName, new ColNameAnnoInfo());
    }

    public void putPrimaryColNames(String primaryCol, ColumnInfo columnInfo) {
        this.primaryColNames.put(primaryCol, columnInfo);
    }

    void putOriginalColNameAndFieldOfModelField(String colName, Field field) {
        List<Field> fields = this.originalColNameOfModelField.get(colName);
        if (fields == null) {
            fields = new ArrayList<Field>();
            this.originalColNameOfModelField.put(colName, fields);
        }
        fields.add(field);
    }

    void putSqlFun(String colName, boolean isFunFun) {
        ColNameAnnoInfo colNameAnnoInfo = this.getColNameAnnoInfoOrCreate(colName);
        colNameAnnoInfo.setSqlFun(isFunFun);
    }

    void putFieldNameAndField(String fieldName, Field field) {
        this.fieldNameAndFields.put(fieldName, field);
    }

    void putColNameExcludeColAll(String colName, boolean isFunGroup) {
        ColNameAnnoInfo colNameAnnoInfo = this.getColNameAnnoInfoOrCreate(colName);
        colNameAnnoInfo.setExcludeColAll(isFunGroup);
    }

    void putDeriveColName(DeriveFlag deriveFlag, DeriveInfo colName) {
        this.deriveColName.put(deriveFlag, colName);
    }

    public DeriveInfo getDeriveColName(DeriveFlag deriveFlag) {
        return this.deriveColName.get((Object)deriveFlag);
    }

    public void unmodifiable() {
        this.colNames = Collections.unmodifiableMap(this.colNames);
        this.fieldNameMappingcolNameOfModel = Collections.unmodifiableMap(this.fieldNameMappingcolNameOfModel);
        this.colNameMappingModelFields = Collections.unmodifiableMap(this.colNameMappingModelFields);
        this.primaryColNames = Collections.unmodifiableMap(this.primaryColNames);
        this.originalColNameOfModelField = Collections.unmodifiableMap(this.originalColNameOfModelField);
        this.fieldNameAndFields = Collections.unmodifiableMap(this.fieldNameAndFields);
        this.deriveColName = Collections.unmodifiableMap(this.deriveColName);
    }
}

