/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.utils;

import com.javaoffers.brief.modelhelper.anno.BaseModel;
import com.javaoffers.brief.modelhelper.exception.BaseException;
import com.javaoffers.brief.modelhelper.exception.ClassNotFindException;
import com.javaoffers.brief.modelhelper.exception.ParseModelException;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.BlurUtils;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.SoftCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public class Utils {
    static Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final SoftCache<Class, Set<Field>> SOFT_CACHE_CLASS_FIELDS = SoftCache.getInstance();
    private static final SoftCache<Field, Boolean> SOFT_CACHE_FIELDS_IS_MODEL = SoftCache.getInstance();
    private static final SoftCache<Class, Boolean> SOFT_CACHE_ClASS_IS_MODEL = SoftCache.getInstance();
    private static final SoftCache<Field, Optional<Annotation>> SOFT_CACHE_FIELDS_BLURS = SoftCache.getInstance();

    public static Annotation getBlurAnnotation(Field field) {
        if (field == null) {
            return null;
        }
        Optional<Annotation> annotation = SOFT_CACHE_FIELDS_BLURS.get(field);
        if (annotation == null) {
            Annotation[] declaredAnnotations;
            annotation = Optional.empty();
            for (Annotation annotation0 : declaredAnnotations = field.getDeclaredAnnotations()) {
                if (!BlurUtils.isBlurAnno(annotation0.annotationType())) continue;
                annotation = Optional.of(annotation0);
                break;
            }
            SOFT_CACHE_FIELDS_BLURS.put(field, annotation);
        }
        if (annotation.isPresent()) {
            return annotation.get();
        }
        return null;
    }

    public static <E> Set<Field> getFields(Class<E> clazz) {
        return Utils.getFields(clazz, false);
    }

    private static <E> Set<Field> getFields(Class<E> clazz, boolean isParentClass) {
        if (clazz == null || clazz.isPrimitive() || clazz.isInterface()) {
            return Collections.EMPTY_SET;
        }
        Set<Field> result = SOFT_CACHE_CLASS_FIELDS.get(clazz);
        if (result == null) {
            LinkedHashSet<Field> list = new LinkedHashSet<Field>();
            if (!clazz.getName().equals("java.lang.Object")) {
                Field[] fields;
                for (Field f : fields = clazz.getDeclaredFields()) {
                    f.setAccessible(true);
                    list.add(f);
                }
                list.addAll(Utils.getFields(clazz.getSuperclass(), true));
            }
            result = list;
            if (!isParentClass) {
                SOFT_CACHE_CLASS_FIELDS.put(clazz, result);
            }
        }
        return result;
    }

    public static boolean isBaseModel(Field fd) {
        Boolean isBaseModel = SOFT_CACHE_FIELDS_IS_MODEL.get(fd);
        if (isBaseModel != null) {
            return isBaseModel;
        }
        isBaseModel = false;
        Class<?> type = fd.getType();
        if (type.isArray()) {
            String typeName = fd.getGenericType().getTypeName();
            try {
                Class<?> class1 = Class.forName(typeName.substring(0, typeName.length() - 2));
                if (Utils.isBaseModel(class1)) {
                    isBaseModel = true;
                }
            }
            catch (Exception exception) {}
        } else if (List.class.isAssignableFrom(type)) {
            isBaseModel = Utils.isModelForListAndSet(fd);
        } else if (Set.class.isAssignableFrom(type)) {
            isBaseModel = Utils.isModelForListAndSet(fd);
        } else {
            BaseModel[] bm = (BaseModel[])type.getAnnotationsByType(BaseModel.class);
            if (bm != null && bm.length > 0) {
                isBaseModel = true;
            }
        }
        SOFT_CACHE_FIELDS_IS_MODEL.put(fd, isBaseModel);
        return isBaseModel;
    }

    public static boolean isModelForListAndSet(Field fd) {
        try {
            ParameterizedType listGenericType = (ParameterizedType)fd.getGenericType();
            Type listActualTypeArguments = listGenericType.getActualTypeArguments()[0];
            Class<?> forName = Class.forName(listActualTypeArguments.getTypeName());
            if (Utils.isBaseModel(forName)) {
                return true;
            }
        }
        catch (Exception e2) {
            new BaseException(e2.getMessage() + "One-to-many relationship. Note that the reference collection class must be added with a generic class. For example: List<Model>, Model cannot be omitted").printStackTrace();
        }
        return false;
    }

    public static boolean isBaseModel(Class clazz) {
        Boolean isBaseModel = SOFT_CACHE_ClASS_IS_MODEL.get(clazz);
        if (isBaseModel != null) {
            return isBaseModel;
        }
        isBaseModel = false;
        BaseModel[] bm = (BaseModel[])clazz.getAnnotationsByType(BaseModel.class);
        if (bm != null && bm.length > 0) {
            isBaseModel = true;
        }
        SOFT_CACHE_ClASS_IS_MODEL.put(clazz, isBaseModel);
        return isBaseModel;
    }

    public static List<Class> parseAllModelClass(Class clazz) {
        LinkedList<Class> modelClassList = new LinkedList<Class>();
        LinkedList<Class> noneModelClassList = new LinkedList<Class>();
        try {
            Utils.parseAllModelClass(clazz, modelClassList, noneModelClassList);
        }
        catch (Exception e) {
            throw new ParseModelException("parse model class is error", e);
        }
        return modelClassList;
    }

    private static void parseAllModelClass(Class clazz, List<Class> modelClassList, List<Class> noneModelClass) throws Exception {
        boolean isModelClass = Utils.isBaseModel(clazz);
        if (isModelClass) {
            if (!modelClassList.contains(clazz)) {
                modelClassList.add(clazz);
                Utils.parseModelClassFromFields(clazz, modelClassList, noneModelClass);
            }
        } else {
            Utils.parseModelClassFromFields(clazz, modelClassList, noneModelClass);
        }
    }

    private static void parseModelClassFromFields(Class clazz, List<Class> modelClassList, List<Class> noneModelClass) throws Exception {
        Set<Field> fields = Utils.getFields(clazz);
        for (Field field : fields) {
            if (Utils.isPrimitive(field)) continue;
            boolean fieldIsModelClass = Utils.isBaseModel(field);
            if (fieldIsModelClass) {
                Class modelClass = Utils.getModelClass(field);
                Utils.parseAllModelClass(modelClass, modelClassList, noneModelClass);
                continue;
            }
            Class genericityClass = Utils.getGenericityClass(field);
            if (noneModelClass.contains(genericityClass)) continue;
            noneModelClass.add(genericityClass);
            Utils.parseAllModelClass(genericityClass, modelClassList, noneModelClass);
        }
    }

    public static boolean isPrimitive(Field field) {
        Class<?> type = field.getType();
        if (type.isPrimitive()) {
            return true;
        }
        try {
            Utils.getGenericityClass(field);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    public static Class getGenericityClass(Field fd) throws Exception {
        return Utils.getModelClass(fd);
    }

    public static Class getModelClass(Field fd) throws Exception {
        Class<?> type2 = fd.getType();
        if (type2.isArray()) {
            String typeName = fd.getGenericType().getTypeName();
            type2 = Class.forName(typeName.substring(0, typeName.length() - 2));
        } else if (List.class.isAssignableFrom(type2)) {
            type2 = Utils.getGenericityClassOfCollect(fd);
        } else if (Set.class.isAssignableFrom(type2)) {
            type2 = Utils.getGenericityClassOfCollect(fd);
        }
        return type2;
    }

    public static Type getModelClass(Class briefMapperClass) {
        Assert.isTrue(briefMapperClass.isInterface(), briefMapperClass.getName() + " must be a Interface");
        Type[] types = briefMapperClass.getGenericInterfaces();
        ParameterizedTypeImpl parameterizedTypes = (ParameterizedTypeImpl)types[0];
        Type modelclass = parameterizedTypes.getActualTypeArguments()[0];
        return modelclass;
    }

    public static Class getGenericityClassOfCollect(Field fd) throws ClassNotFoundException {
        try {
            ParameterizedType listGenericType = (ParameterizedType)fd.getGenericType();
            Type listActualTypeArguments = listGenericType.getActualTypeArguments()[0];
            return Class.forName(listActualTypeArguments.getTypeName());
        }
        catch (Exception e) {
            logger.debug(e.getMessage() + "One-to-many relationship. Note that the reference collection class must be added with a generic class. For example: List<Model>, Model cannot be omitted");
            throw e;
        }
    }

    public static String getSpecialColName(String tableName, DBType dbType, String colName) {
        switch (dbType) {
            case MYSQL: {
                return tableName + "__" + colName;
            }
            case H2: {
                return tableName.toUpperCase() + "__" + colName.toUpperCase();
            }
        }
        return tableName + "__" + colName;
    }

    public static Class getClass(String className) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new ClassNotFindException(e.getMessage(), e);
        }
        return aClass;
    }

    public static Set<Class> getSupperClass(Class clazz) {
        HashSet<Class> classes = new HashSet<Class>();
        Class superclass = clazz.getSuperclass();
        if (superclass == null) {
            return classes;
        }
        classes.add(superclass);
        classes.addAll(Utils.getSupperClass(superclass));
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return classes;
        }
        for (Class<?> inte : interfaces) {
            classes.add(inte);
            classes.addAll(Utils.getSupperClass(inte));
        }
        return classes;
    }

    public static Class baseClassUpgrade(Class baseClass) {
        if (baseClass.isPrimitive()) {
            if (Boolean.TYPE == baseClass) {
                return Boolean.class;
            }
            if (Character.TYPE == baseClass) {
                return Character.class;
            }
            if (Byte.TYPE == baseClass) {
                return Byte.class;
            }
            if (Short.TYPE == baseClass) {
                return Short.class;
            }
            if (Integer.TYPE == baseClass) {
                return Integer.class;
            }
            if (Long.TYPE == baseClass) {
                return Long.class;
            }
            if (Float.TYPE == baseClass) {
                return Float.class;
            }
            if (Double.TYPE == baseClass) {
                return Double.class;
            }
            if (Void.TYPE == baseClass) {
                return Void.class;
            }
        } else if (baseClass.isEnum()) {
            return Enum.class;
        }
        return baseClass;
    }

    public static String conLine(String info) {
        if (info.contains("_")) {
            return info;
        }
        String[] split = info.split("");
        StringBuilder builder = new StringBuilder();
        String last = null;
        for (String s : split) {
            if (StringUtils.isAllUpperCase((CharSequence)s) && builder.length() != 0 && StringUtils.isAllLowerCase(last)) {
                s = s.toLowerCase();
                s = "_" + s;
            }
            builder.append(s);
            last = s;
        }
        info = builder.toString();
        String defaultCase = "NO";
        String YES = "YES";
        String ignoreCase = System.getProperty("LowerCase", defaultCase);
        String upperCase = System.getProperty("UpperCase", defaultCase);
        info = YES.equalsIgnoreCase(ignoreCase) ? info.toLowerCase() : (YES.equalsIgnoreCase(upperCase) ? info.toUpperCase() : info.toLowerCase());
        return info;
    }
}

