/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.context;

import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.context.BriefContextPostProcess;
import com.javaoffers.brief.modelhelper.context.BriefProperties;
import com.javaoffers.brief.modelhelper.context.BriefPropertiesLoader;
import com.javaoffers.brief.modelhelper.context.DeriveProcess;
import com.javaoffers.brief.modelhelper.context.JqlInterceptor;
import com.javaoffers.brief.modelhelper.context.SmartBriefProperties;
import com.javaoffers.brief.modelhelper.context.SmartTableInfoParser;
import com.javaoffers.brief.modelhelper.filter.JqlExecutorFilter;
import com.javaoffers.brief.modelhelper.jdbc.BriefJdbcExecutorFactory;
import com.javaoffers.brief.modelhelper.jdbc.JdbcExecutorFactory;
import com.javaoffers.brief.modelhelper.mapper.BriefMapper;
import com.javaoffers.brief.modelhelper.mapper.SmartMapperProxy;
import com.javaoffers.brief.modelhelper.parser.StatementParser;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.BriefUtils;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.JdkProxyUtils;
import com.javaoffers.brief.modelhelper.utils.Lists;
import com.javaoffers.brief.modelhelper.utils.ReflectionUtils;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

public abstract class SmartBriefContext
implements BriefContext {
    private SmartBriefProperties smartBriefProperties = new SmartBriefProperties();
    private Map<Class, BriefMapper> cache = new ConcurrentHashMap<Class, BriefMapper>();
    private static List<BriefPropertiesLoader> briefPropertiesLoaderList = new ArrayList<BriefPropertiesLoader>(ReflectionUtils.getChildInstance(BriefPropertiesLoader.class));
    private static List<BriefContextPostProcess> briefContextPostProcessList = new ArrayList<BriefContextPostProcess>(ReflectionUtils.getChildInstance(BriefContextPostProcess.class));
    private static List<BriefContextAware> briefContextAwareList = new ArrayList<BriefContextAware>(ReflectionUtils.getChildInstance(BriefContextAware.class));
    private static List<JqlExecutorFilter> jqlExecutorFilters = new ArrayList<JqlExecutorFilter>(ReflectionUtils.getChildInstance(JqlExecutorFilter.class));
    private static List<DeriveProcess> deriveProcessList = new ArrayList<DeriveProcess>(ReflectionUtils.getChildInstance(DeriveProcess.class));
    private static final ArrayList<JqlInterceptor> coreInterceptorsList = Lists.newArrayList();
    private static final Map<DBType, StatementParser> statementParserMap = new HashMap<DBType, StatementParser>();
    private static final SmartTableInfoParser smartTableInfoParser = new SmartTableInfoParser();

    public SmartBriefContext(SmartBriefProperties smartBriefProperties) {
        this.smartBriefProperties = smartBriefProperties;
    }

    public SmartBriefContext() {
    }

    public SmartBriefProperties getBriefProperties() {
        return this.smartBriefProperties;
    }

    public abstract DataSource getDataSource();

    public JdbcExecutorFactory getJdbcExecutorFactory() {
        return BriefJdbcExecutorFactory.instance;
    }

    public BriefMapper getBriefMapper(Class briefMapper) {
        Assert.isTrue((boolean)BriefMapper.class.isAssignableFrom(briefMapper), (String)(briefMapper.getName() + " must be BriefMapper subclass"));
        BriefMapper mapper = this.cache.get(briefMapper);
        if (mapper == null) {
            Type modelClass = Utils.getModelClass((Class)briefMapper);
            Object briefMapperImpl = BriefUtils.newCrudMapper(briefMapper);
            SmartMapperProxy smartMapperProxy = new SmartMapperProxy((BriefMapper)briefMapperImpl, this.getDataSource(), (Class)modelClass);
            this.cache.putIfAbsent(briefMapper, (BriefMapper)JdkProxyUtils.createProxy((Class)briefMapper, (InvocationHandler)smartMapperProxy));
            mapper = this.cache.get(briefMapper);
        }
        return mapper;
    }

    public List<JqlInterceptor> getJqlInterceptors() {
        return coreInterceptorsList;
    }

    public List<JqlExecutorFilter> getJqlExecutorFilters() {
        return jqlExecutorFilters;
    }

    public StatementParser getStatementParser(DBType dbType) {
        return statementParserMap.get(dbType);
    }

    public SmartTableInfoParser getTableInfoParser() {
        return smartTableInfoParser;
    }

    public List<DeriveProcess> getDeriveProcess() {
        return deriveProcessList;
    }

    public Map<DBType, StatementParser> getStatementParserMap() {
        return statementParserMap;
    }

    public void fresh() {
        this.initProperties();
        this.initContextPostProcess();
        this.finish();
    }

    private void initProperties() {
        for (BriefPropertiesLoader briefPropertiesLoader : briefPropertiesLoaderList) {
            briefPropertiesLoader.startLoader((BriefProperties)this.getBriefProperties());
        }
        this.smartBriefProperties.fresh();
    }

    private void finish() {
        for (BriefContextAware briefContextAware : briefContextAwareList) {
            briefContextAware.setBriefContext((BriefContext)this);
        }
    }

    protected void initContextPostProcess() {
        for (BriefContextPostProcess briefContextPostProcess : briefContextPostProcessList) {
            briefContextPostProcess.postProcess((BriefContext)this);
        }
    }
}

