/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.context;

import com.javaoffers.brief.modelhelper.context.BriefProperties;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class SmartBriefProperties
implements BriefProperties {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private final Properties bp = System.getProperties();
    private volatile long showLogTime = -1L;
    private volatile boolean isPrintSql;
    private volatile boolean isPrintSqlCost;

    public SmartBriefProperties put(String key, String value) {
        this.bp.setProperty(key, value);
        this.properties.put(key, value);
        return this;
    }

    public void fresh() {
        this.initShowLogTime();
        this.initIsPrintSql();
        this.initIsPrintSqlCost();
    }

    public SmartBriefProperties isPrintSql(String isPrintSql) {
        this.put("brief:print-sql", isPrintSql.trim().toLowerCase());
        return this;
    }

    public SmartBriefProperties isPrintSqlCost(String isPrintSqlCost) {
        this.put("brief:print-cost", isPrintSqlCost.trim().toLowerCase());
        return this;
    }

    public SmartBriefProperties setSlowSqlLogTime(String slowLogTime) {
        this.put("brief:slow-sql:time", slowLogTime);
        return this;
    }

    public long getSlowSqlTimeThreshold() {
        return this.showLogTime;
    }

    public boolean isPrintSql() {
        return this.isPrintSql;
    }

    public boolean isPrintSqlCost() {
        return this.isPrintSqlCost;
    }

    public void initIsPrintSql() {
        this.isPrintSql = Boolean.parseBoolean(this.bp.getProperty("brief:print-sql", "true"));
    }

    public void initIsPrintSqlCost() {
        this.isPrintSqlCost = Boolean.parseBoolean(this.bp.getProperty("brief:print-cost", "true"));
    }

    public void initShowLogTime() {
        String mls = this.bp.getProperty("brief:slow-sql:time");
        if (StringUtils.isNotBlank((CharSequence)mls)) {
            this.showLogTime = Long.parseLong(mls.trim());
        }
    }
}

