/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.context;

import com.javaoffers.brief.modelhelper.anno.BaseUnique;
import com.javaoffers.brief.modelhelper.anno.NoneCol;
import com.javaoffers.brief.modelhelper.exception.BriefException;
import com.javaoffers.brief.modelhelper.parser.TableInfoParser;
import com.javaoffers.brief.modelhelper.utils.ColumnInfo;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.ReflectionUtils;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SmartTableInfoParser
implements TableInfoParser {
    private static final Map<DBType, TableInfoParser> tableInfoParserMap = new HashMap<DBType, TableInfoParser>();
    static Set<TableInfoParser> childInstance = ReflectionUtils.getChildInstance(TableInfoParser.class);

    public void parseTableInfo(Connection connection, TableInfo tableInfo) {
        this.chose(connection).parseTableInfo(connection, tableInfo);
    }

    public void parseTableInfo(TableInfo tableInfo) {
        DBType dbType = this.getDBType();
        tableInfo.setDbType(dbType);
        List filedList = Utils.getFields((Class)tableInfo.getModelClass()).stream().filter(field -> field.getDeclaredAnnotation(NoneCol.class) == null && !Utils.isBaseModel((Field)field) && !field.getType().isAssignableFrom(Collection.class) && !field.getType().isAssignableFrom(Map.class)).collect(Collectors.toList());
        filedList.stream().filter(field -> field.getDeclaredAnnotation(BaseUnique.class) != null).forEach(field -> {
            BaseUnique baseUniqueAnno = field.getDeclaredAnnotation(BaseUnique.class);
            String columnName = Utils.conLine((String)field.getName());
            if (StringUtils.isNotBlank((CharSequence)baseUniqueAnno.value())) {
                columnName = baseUniqueAnno.value();
            }
            ColumnInfo columnInfo = new ColumnInfo(columnName);
            tableInfo.putPrimaryColNames(columnName, columnInfo);
            tableInfo.getColumnInfos().add(columnInfo);
            tableInfo.putColNames(columnName, columnInfo);
        });
        filedList.stream().filter(field -> {
            Annotation[] declaredAnnotations = field.getDeclaredAnnotations();
            if (declaredAnnotations == null || declaredAnnotations.length == 0) {
                return true;
            }
            for (Annotation annotation : declaredAnnotations) {
                boolean contains = annotation.getClass().getName().contains("com.javaoffers.brief.modelhelper.anno");
                if (!contains) continue;
                return true;
            }
            return false;
        }).forEach(field -> {
            String columnName = Utils.conLine((String)field.getName());
            ColumnInfo columnInfo = new ColumnInfo(columnName);
            tableInfo.getColumnInfos().add(columnInfo);
            tableInfo.putColNames(columnName, columnInfo);
        });
    }

    public TableInfoParser chose(Connection connection) {
        try {
            String url = connection.getMetaData().getURL().toLowerCase();
            List dbTypeList = tableInfoParserMap.keySet().stream().filter(dbType -> url.contains("jdbc:" + dbType.toString().toLowerCase())).collect(Collectors.toList());
            if (dbTypeList.size() != 1) {
                throw new BriefException("chose db type error");
            }
            return tableInfoParserMap.get(dbTypeList.get(0));
        }
        catch (Exception e) {
            throw new BriefException("chose db type error");
        }
    }

    public DBType getDBType() {
        throw new UnsupportedOperationException();
    }

    static {
        childInstance.stream().filter(tableInfoParser -> tableInfoParser.getClass() != SmartTableInfoParser.class).forEach(tableInfoParser -> tableInfoParserMap.put(tableInfoParser.getDBType(), (TableInfoParser)tableInfoParser));
    }
}

