/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.context.SmartBriefContext;
import com.javaoffers.brief.modelhelper.core.BaseBrief;
import com.javaoffers.brief.modelhelper.core.BaseBriefImplProxy;
import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.core.SQL;
import com.javaoffers.brief.modelhelper.core.SQLParse;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.jdbc.JdbcExecutor;
import com.javaoffers.brief.modelhelper.jdbc.JdbcExecutorFactory;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.SQLType;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class BaseBriefImpl<T, ID>
implements BaseBrief<T>,
BriefContextAware {
    private static JdbcExecutorFactory jdbcExecutorFactory;
    private JdbcExecutor<T> jdbcExecutor;
    private DBType dbType;

    public BaseBriefImpl() {
    }

    public static <T, ID> BaseBrief getInstance(HeadCondition headCondition) {
        return BaseBriefImpl.getInstance(headCondition.getDataSource(), headCondition.getModelClass());
    }

    private static <T, ID> BaseBrief getInstance(DataSource dataSource, Class mClass) {
        BaseBriefImpl<T, ID> batis = new BaseBriefImpl<T, ID>(dataSource, mClass);
        return new BaseBriefImplProxy(batis, mClass);
    }

    private BaseBriefImpl(DataSource dataSource, Class modelClass) {
        this.jdbcExecutor = jdbcExecutorFactory.createJdbcExecutor(dataSource, modelClass);
        this.dbType = TableHelper.getTableInfo((Class)modelClass).getDbType();
    }

    @Override
    public int saveData(String sql) {
        return this.saveData(sql, Collections.EMPTY_MAP);
    }

    @Override
    public int saveData(String sql, Map<String, Object> map) {
        SQL sql_ = SQLParse.getSQL(this.dbType, sql, map);
        return this.jdbcExecutor.save((BaseSQLInfo)sql_).toInt();
    }

    @Override
    public int deleteData(String sql) {
        return this.deleteData(sql, Collections.EMPTY_MAP);
    }

    @Override
    public int deleteData(String sql, Map<String, Object> map) {
        SQL sql_ = SQLParse.getSQL(this.dbType, sql, map);
        return this.jdbcExecutor.modify((BaseSQLInfo)sql_);
    }

    @Override
    public int updateData(String sql) {
        return this.updateData(sql, Collections.EMPTY_MAP);
    }

    @Override
    public int updateData(String sql, Map<String, Object> map) {
        SQL sql_ = SQLParse.getSQL(this.dbType, sql, map);
        return this.jdbcExecutor.modify((BaseSQLInfo)sql_);
    }

    @Override
    public List<T> queryData(String sql) {
        return this.queryData(sql, new HashMap<String, Object>());
    }

    @Override
    public List<T> queryData(String sql, Map<String, Object> paramMap) {
        ArrayList<Map<String, Object>> paramMapList = new ArrayList<Map<String, Object>>();
        paramMapList.add(paramMap);
        SQL querySql = SQLParse.parseSqlParams(this.dbType, sql, paramMapList);
        return this.jdbcExecutor.queryList((BaseSQLInfo)querySql);
    }

    @Override
    public void queryStream(String sql, Map<String, Object> paramMap, Consumer<T> consumer) {
        ArrayList<Map<String, Object>> paramMapList = new ArrayList<Map<String, Object>>();
        paramMapList.add(paramMap);
        SQL querySql = SQLParse.parseSqlParams(this.dbType, sql, paramMapList);
        querySql.setStreaming(consumer);
        this.jdbcExecutor.queryStream((BaseSQLInfo)querySql);
    }

    @Override
    public List<String> nativeData(String sql, SQLType sqlType) {
        return this.nativeData(sql, new HashMap<String, Object>(), sqlType);
    }

    @Override
    public List<String> nativeData(String sql, Map<String, Object> paramMap, SQLType sqlType) {
        ArrayList<Map<String, Object>> paramMapList = new ArrayList<Map<String, Object>>();
        paramMapList.add(paramMap);
        SQL querySql = SQLParse.parseSqlParams(this.dbType, sql, paramMapList);
        querySql.setSqlType(sqlType);
        return this.jdbcExecutor.queryList((BaseSQLInfo)querySql);
    }

    @Override
    public Integer batchUpdate(String sql, List<Map<String, Object>> paramMap) {
        SQL batchSQL = SQLParse.parseSqlParams(this.dbType, sql, paramMap);
        return this.jdbcExecutor.batchModify((BaseSQLInfo)batchSQL);
    }

    @Override
    public List<Id> batchInsert(String sql, List<Map<String, Object>> paramMap) {
        SQL pss = SQLParse.parseSqlParams(this.dbType, sql, paramMap);
        return this.jdbcExecutor.batchSave((BaseSQLInfo)pss);
    }

    public void setBriefContext(BriefContext briefContext) {
        SmartBriefContext smartBriefContext = (SmartBriefContext)briefContext;
        jdbcExecutorFactory = smartBriefContext.getJdbcExecutorFactory();
    }
}

