/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.context.SmartBriefContext;
import com.javaoffers.brief.modelhelper.core.BaseBrief;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.filter.JqlExecutorChain;
import com.javaoffers.brief.modelhelper.filter.JqlExecutorFilter;
import com.javaoffers.brief.modelhelper.filter.JqlMetaInfo;
import com.javaoffers.brief.modelhelper.utils.SQLType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;

public class BaseBriefImplProxy<T, ID>
implements BaseBrief<T>,
BriefContextAware {
    private static List<JqlExecutorFilter> jqlExecutorChains = new ArrayList<JqlExecutorFilter>();
    private BaseBrief baseBrief;
    private Class modelClass;

    public BaseBriefImplProxy(BaseBrief baseBrief, Class modelClass) {
        this.baseBrief = baseBrief;
        this.modelClass = modelClass;
    }

    public BaseBriefImplProxy() {
    }

    private <R> R doProxy(JqlMetaInfo jqlMetaInfo, Function<JqlMetaInfo, R> supplier) {
        JqlExecutorChain jqlExecutorChain = new JqlExecutorChain(supplier, jqlExecutorChains, jqlMetaInfo);
        return (R)jqlExecutorChain.doChain();
    }

    @Override
    public int saveData(String sql) {
        return this.doProxy(new JqlMetaInfo(sql, this.modelClass), jmi -> this.baseBrief.saveData(jmi.getSql()));
    }

    @Override
    public int saveData(String sql, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> this.baseBrief.saveData(jmi.getSql(), map));
    }

    @Override
    public int deleteData(String sql) {
        return this.doProxy(new JqlMetaInfo(sql, this.modelClass), jmi -> this.baseBrief.deleteData(jmi.getSql()));
    }

    @Override
    public int deleteData(String sql, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> this.baseBrief.deleteData(jmi.getSql(), map));
    }

    @Override
    public int updateData(String sql) {
        return this.doProxy(new JqlMetaInfo(sql, this.modelClass), jmi -> this.baseBrief.updateData(jmi.getSql()));
    }

    @Override
    public int updateData(String sql, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> this.baseBrief.updateData(jmi.getSql(), map));
    }

    @Override
    public List<T> queryData(String sql) {
        return this.doProxy(new JqlMetaInfo(sql, this.modelClass), jmi -> this.baseBrief.queryData(jmi.getSql()));
    }

    @Override
    public List<T> queryData(String sql, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> this.baseBrief.queryData(jmi.getSql(), map));
    }

    @Override
    public void queryStream(String sql, Map<String, Object> map, Consumer<T> consumer) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> {
            this.baseBrief.queryStream(jmi.getSql(), map, consumer);
            return 0;
        });
    }

    @Override
    public List<String> nativeData(String sql, SQLType sqlType) {
        return this.doProxy(new JqlMetaInfo(sql, this.modelClass), jmi -> this.baseBrief.nativeData(jmi.getSql(), sqlType));
    }

    @Override
    public List<String> nativeData(String sql, Map<String, Object> map, SQLType sqlType) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return this.doProxy(new JqlMetaInfo(sql, maps, this.modelClass), jmi -> this.baseBrief.nativeData(jmi.getSql(), map, sqlType));
    }

    @Override
    public Integer batchUpdate(String sql, List<Map<String, Object>> paramMap) {
        JqlMetaInfo jqlMetaInfo = new JqlMetaInfo(sql, paramMap, this.modelClass);
        return this.doProxy(jqlMetaInfo, jmi -> this.baseBrief.batchUpdate(jmi.getSql(), paramMap));
    }

    @Override
    public List<Id> batchInsert(String sql, List<Map<String, Object>> paramMap) {
        JqlMetaInfo jqlMetaInfo = new JqlMetaInfo(sql, paramMap, this.modelClass);
        return this.doProxy(jqlMetaInfo, jmi -> this.baseBrief.batchInsert(jmi.getSql(), paramMap));
    }

    public void setBriefContext(BriefContext briefContext) {
        SmartBriefContext smartBriefContext = (SmartBriefContext)briefContext;
        jqlExecutorChains = smartBriefContext.getJqlExecutorFilters();
    }
}

