/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.update.UpdateCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LFCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrderWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;

public class LinkedConditions<T extends Condition>
extends LinkedList<T>
implements BriefContextAware {
    private List<BiConsumer<T, T>> beforeAddProcess = new LinkedList<BiConsumer<T, T>>();
    private static BriefContext briefContext;

    public LinkedConditions() {
        this.beforeAdd((before, current) -> {
            if (before == null) {
                return;
            }
            if (before instanceof OrderWordCondition && current instanceof OrderWordCondition) {
                ((OrderWordCondition)current).asChild();
            } else if (before instanceof LFCondition && current instanceof WhereOnCondition) {
                ((WhereOnCondition)current).cleanAndOrTag();
            }
        });
    }

    @Override
    public boolean add(T condition) {
        this.beforeAddProcess.forEach(biConsumer -> biConsumer.accept(this.peekLast(), condition));
        if (condition instanceof WhereOnCondition) {
            ((WhereOnCondition)condition).setHeadCondition((HeadCondition)this.peekFirst());
        } else if (condition instanceof UpdateCondition) {
            ((UpdateCondition)condition).setHeadCondition((HeadCondition)this.peekFirst());
        } else if (condition instanceof HeadCondition && this.peekFirst() instanceof HeadCondition) {
            this.pollFirst();
            this.addFirst(condition);
            return true;
        }
        return super.add(condition);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        c.forEach(a -> this.add((T)a));
        return true;
    }

    private void beforeAdd(BiConsumer<T, T> biConsumer) {
        this.beforeAddProcess.add(biConsumer);
    }

    public void setBriefContext(BriefContext briefContext) {
        LinkedConditions.briefContext = briefContext;
    }
}

