/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.SQLType;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class SQL
implements BaseSQLInfo {
    static final String innerJoin = ConditionTag.INNER_JOIN.getTag().trim().toLowerCase();
    static final String leftJoin = ConditionTag.LEFT_JOIN.getTag().trim().toLowerCase();
    static final String rightJoin = ConditionTag.RIGHT_JOIN.getTag().trim().toLowerCase();
    static final String normalSelect = ConditionTag.SELECT.getTag().trim().toLowerCase();
    static final String normalFrom = ConditionTag.SELECT_FROM.getTag().trim().toLowerCase();
    private List<Object[]> argsParam;
    private String sql;
    List<Map<String, Object>> paramMap;
    SQLType sqlType;
    DBType dbType;
    Consumer consumer;

    public SQL(DBType dbType, String sql, List<Object[]> argsParam) {
        this.argsParam = argsParam;
        this.sql = sql;
        this.dbType = dbType;
        String tmpSql = this.sql.toLowerCase();
        if (tmpSql.contains(innerJoin) || tmpSql.contains(leftJoin) || tmpSql.contains(rightJoin)) {
            this.sqlType = SQLType.JOIN_SELECT;
        } else if (tmpSql.contains(normalSelect) || tmpSql.contains(normalFrom)) {
            this.sqlType = SQLType.NORMAL_SELECT;
        }
    }

    public String getSql() {
        return this.sql;
    }

    public List<Map<String, Object>> getParams() {
        return this.paramMap;
    }

    public void resetSql(String sql) {
        this.sql = sql;
    }

    public List<Object[]> getArgsParam() {
        return this.argsParam;
    }

    public SQLType getSqlType() {
        return this.sqlType;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public Consumer getStreaming() {
        return this.consumer;
    }

    public void setStreaming(Consumer consumer) {
        this.consumer = consumer;
    }

    public void setSqlType(SQLType sqlType) {
        this.sqlType = sqlType;
    }

    public int getBatchSize() {
        if (this.argsParam != null) {
            return this.argsParam.size();
        }
        return 0;
    }

    public void setParamMap(List<Map<String, Object>> paramMap) {
        this.paramMap = paramMap;
    }
}

