/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.context.BriefContext;
import com.javaoffers.brief.modelhelper.context.BriefContextAware;
import com.javaoffers.brief.modelhelper.context.JqlInterceptor;
import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.core.SQL;
import com.javaoffers.brief.modelhelper.utils.DBType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLParse
implements BriefContextAware {
    private String sql;
    private String param;
    public static final String p = "(\\#\\{[0-9a-zA-Z-_]+\\})";
    public static final Pattern compile = Pattern.compile("(\\#\\{[0-9a-zA-Z-_]+\\})");
    private static List<JqlInterceptor> jqlInterceptorList;

    SQLParse() {
    }

    private static String parseSql(String sql) {
        String s = sql.replaceAll(p, "?");
        return s;
    }

    public static SQL parseSqlParams(DBType dbType, String sql, List<Map<String, Object>> paramMap) {
        ArrayList<Object[]> objects = new ArrayList<Object[]>(paramMap.size());
        ArrayList<String> keys = new ArrayList<String>();
        Matcher matcher = compile.matcher(sql);
        while (matcher.find()) {
            String result = matcher.group(1);
            String paramKey = result.substring(2, result.length() - 1);
            keys.add(paramKey);
        }
        sql = SQLParse.parseSql(sql);
        SQL SQL2 = new SQL(dbType, sql, objects);
        SQL2.setParamMap(paramMap);
        for (JqlInterceptor jqlInterceptor : jqlInterceptorList) {
            jqlInterceptor.handler((BaseSQLInfo)SQL2);
        }
        int i = 0;
        for (int j = paramMap.size() - 1; paramMap != null && i <= j; ++i, --j) {
            if (i == j) {
                Map<String, Object> pm = paramMap.get(i);
                Object[] params = new Object[keys.size()];
                for (int k = 0; k < keys.size(); ++k) {
                    String paramKey = (String)keys.get(k);
                    params[k] = pm.get(paramKey);
                }
                objects.add(params);
                continue;
            }
            Map<String, Object> pmLeft = paramMap.get(i);
            Map<String, Object> pmRight = paramMap.get(j);
            Object[] paramsLeft = new Object[keys.size()];
            Object[] paramsRight = new Object[keys.size()];
            for (int k = 0; k < keys.size(); ++k) {
                String paramKey = (String)keys.get(k);
                paramsLeft[k] = pmLeft.get(paramKey);
                paramsRight[k] = pmRight.get(paramKey);
            }
            objects.add(paramsLeft);
            objects.add(paramsRight);
        }
        return SQL2;
    }

    public static SQL getSQL(DBType dbType, String sql, Map<String, Object> map) {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>();
        maps.add(map);
        return SQLParse.parseSqlParams(dbType, sql, maps);
    }

    public void setBriefContext(BriefContext briefContext) {
        jqlInterceptorList = briefContext.getJqlInterceptors();
    }
}

