/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core.parse;

import com.javaoffers.brief.modelhelper.core.MoreSQLInfo;
import com.javaoffers.brief.modelhelper.core.SQLStatement;
import com.javaoffers.brief.modelhelper.core.parse.AbstractParseCondition;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.condition.ColValueCondition;
import com.javaoffers.brief.modelhelper.fun.condition.insert.InsertAllColValueCondition;
import com.javaoffers.brief.modelhelper.fun.condition.insert.InsertIntoCondition;
import com.javaoffers.brief.modelhelper.fun.condition.mark.OnDuplicateKeyUpdateMark;
import com.javaoffers.brief.modelhelper.utils.Assert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class InsertConditionParse
extends AbstractParseCondition {
    public static ConditionTag conditionTag = ConditionTag.INSERT_INTO;

    @Override
    public SQLStatement doParse(LinkedList<Condition> conditions) {
        return this.parseInsert(conditions);
    }

    private SQLStatement parseInsert(LinkedList<Condition> conditions) {
        InsertIntoCondition insertIntoTableCondition = (InsertIntoCondition)conditions.pollFirst();
        String insertIntoTableSql = insertIntoTableCondition.getSql();
        ArrayList<String> moreSql = new ArrayList<String>();
        StringBuilder insertColNamesAppender = new StringBuilder();
        StringBuilder insertValueAppender = new StringBuilder();
        ArrayList<Map<String, Object>> paramsList = new ArrayList<Map<String, Object>>();
        HashMap valuesParam = new HashMap();
        boolean isColValueCondition = false;
        boolean isDupUpdateSql = conditions.peekLast() instanceof OnDuplicateKeyUpdateMark;
        ArrayList<String> dupUpdateSql = new ArrayList<String>();
        StringBuilder duplicateSqlForColValCondition = new StringBuilder();
        Condition condition = null;
        while ((condition = conditions.pollFirst()) != null) {
            if (condition instanceof ColValueCondition) {
                Map params = condition.getParams();
                Assert.isTrue((params.size() == 1 ? 1 : 0) != 0, (String)"\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u503c");
                if (insertColNamesAppender.length() == 0) {
                    isColValueCondition = true;
                    insertColNamesAppender.append("(");
                    insertValueAppender.append(ConditionTag.VALUES.getTag());
                    insertValueAppender.append("(");
                    duplicateSqlForColValCondition.append(ConditionTag.ON_DUPLICATE_KEY_UPDATE.getTag());
                } else {
                    insertColNamesAppender.append(",");
                    insertValueAppender.append(",");
                    duplicateSqlForColValCondition.append(",");
                }
                insertColNamesAppender.append(condition.getSql());
                Set strings = params.keySet();
                String key = (String)strings.iterator().next();
                insertValueAppender.append("#{");
                insertValueAppender.append(key);
                insertValueAppender.append("}");
                valuesParam.put(key, params.get(key));
                duplicateSqlForColValCondition.append(condition.getSql());
                duplicateSqlForColValCondition.append(" = ");
                duplicateSqlForColValCondition.append("values(");
                duplicateSqlForColValCondition.append(condition.getSql());
                duplicateSqlForColValCondition.append(") ");
                continue;
            }
            if (!(condition instanceof InsertAllColValueCondition)) continue;
            insertValueAppender = new StringBuilder();
            insertColNamesAppender = new StringBuilder();
            InsertAllColValueCondition allColValueCondition = (InsertAllColValueCondition)condition;
            allColValueCondition.init(isDupUpdateSql);
            insertColNamesAppender.append(allColValueCondition.getSql());
            insertValueAppender.append(ConditionTag.VALUES.getTag());
            insertValueAppender.append(allColValueCondition.getValuesSql());
            paramsList.add(allColValueCondition.getParams());
            moreSql.add(insertColNamesAppender.append(insertValueAppender.toString()).toString());
            if (!isDupUpdateSql) continue;
            dupUpdateSql.add(allColValueCondition.getOnDuplicateString());
        }
        if (isColValueCondition) {
            insertColNamesAppender.append(")");
            insertValueAppender.append(")");
            paramsList.add(valuesParam);
            moreSql.add(insertColNamesAppender.append(insertValueAppender.toString()).toString());
            if (isDupUpdateSql) {
                dupUpdateSql.add(duplicateSqlForColValCondition.toString());
            }
        }
        Assert.isTrue((moreSql.size() == paramsList.size() ? 1 : 0) != 0, (String)" data asymmetry ");
        MoreSQLInfo moreSQLInfo = new MoreSQLInfo();
        HashMap<String, SQLStatement> batch = new HashMap<String, SQLStatement>();
        for (int i = 0; i < moreSql.size(); ++i) {
            String sql = insertIntoTableSql + (String)moreSql.get(i);
            if (isDupUpdateSql) {
                sql = sql + (String)dupUpdateSql.get(i);
            }
            Map sqlParam = (Map)paramsList.get(i);
            SQLStatement sqlStatement = (SQLStatement)batch.get(sql);
            if (sqlStatement == null) {
                ArrayList<Map<String, Object>> parems = new ArrayList<Map<String, Object>>();
                parems.add(sqlParam);
                sqlStatement = SQLStatement.builder().aClass(insertIntoTableCondition.getModelClass()).params(parems).sql(sql).status(true).build();
                batch.put(sql, sqlStatement);
                continue;
            }
            sqlStatement.getParams().add(sqlParam);
        }
        moreSQLInfo.addAllSqlInfo(batch.values());
        return moreSQLInfo;
    }
}

