/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core.parse;

import com.javaoffers.brief.modelhelper.core.SQLStatement;
import com.javaoffers.brief.modelhelper.core.parse.AbstractParseCondition;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.condition.JoinTableCondition;
import com.javaoffers.brief.modelhelper.fun.condition.KeyWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.mark.OnConditionMark;
import com.javaoffers.brief.modelhelper.fun.condition.mark.WhereConditionMark;
import com.javaoffers.brief.modelhelper.fun.condition.select.SelectColumnCondition;
import com.javaoffers.brief.modelhelper.fun.condition.select.SelectTableCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class SelectConditionParse
extends AbstractParseCondition {
    public static ConditionTag conditionTag = ConditionTag.SELECT_FROM;

    @Override
    public SQLStatement doParse(LinkedList<Condition> conditions) {
        return this.parseSelect(conditions);
    }

    private SQLStatement parseSelect(LinkedList<Condition> conditions) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String and = ConditionTag.AND.getTag();
        SelectTableCondition condition = (SelectTableCondition)conditions.pollFirst();
        String fromTable = condition.getSql();
        String frontView = condition.getFrontView();
        StringBuilder selectCols = new StringBuilder(frontView);
        selectCols.append(ConditionTag.SELECT.getTag());
        if (conditions.peekFirst() == null || !(conditions.peekFirst() instanceof SelectColumnCondition)) {
            return null;
        }
        this.beforeSelectCol(conditions, selectCols);
        this.parseSelectClo(conditions, selectCols);
        StringBuilder fromTables = new StringBuilder(fromTable);
        StringBuilder onCondition = new StringBuilder();
        while (conditions.peekFirst() instanceof JoinTableCondition) {
            Condition leftJoin = conditions.pollFirst();
            this.parseSelectCloWithDelimiter(conditions, selectCols);
            fromTables.append(leftJoin.getSql());
            Condition on = null;
            if (conditions.peekFirst() instanceof OnConditionMark) {
                onCondition.append(conditions.pollFirst().getSql());
                onCondition.append("1=1");
                while (!(conditions.peekFirst() instanceof WhereConditionMark)) {
                    on = conditions.pollFirst();
                    if (on instanceof OrCondition) {
                        and = on.getSql();
                        on = conditions.pollFirst();
                    } else if (on instanceof WhereOnCondition) {
                        and = ((WhereOnCondition)on).getAndOrTag();
                    } else if (on instanceof JoinTableCondition) {
                        conditions.addFirst(on);
                        break;
                    }
                    this.whereAndOn(params, onCondition, and, on);
                }
            }
            fromTables.append((CharSequence)onCondition);
            onCondition = new StringBuilder();
        }
        selectCols.append((CharSequence)fromTables);
        this.parseWhereCondition(conditions, params, selectCols);
        return SQLStatement.builder().aClass(condition.getmClass()).params(Arrays.asList(params)).sql(selectCols.toString()).status(true).build();
    }

    public void beforeSelectCol(LinkedList<Condition> conditions, StringBuilder selectCols) {
    }

    public void parseSelectClo(LinkedList<Condition> conditions, StringBuilder selectB) {
        while (conditions.peekFirst() instanceof SelectColumnCondition) {
            SelectColumnCondition selectCol = (SelectColumnCondition)conditions.pollFirst();
            String sql = selectCol.getSql();
            if (selectCol instanceof KeyWordCondition) {
                selectB.append(sql);
                continue;
            }
            selectB.append(sql);
            break;
        }
        this.parseSelectCloWithDelimiter(conditions, selectB);
    }

    public void parseSelectCloWithDelimiter(LinkedList<Condition> conditions, StringBuilder selectB) {
        while (conditions.peekFirst() instanceof SelectColumnCondition) {
            SelectColumnCondition selectCol = (SelectColumnCondition)conditions.pollFirst();
            String sql = selectCol.getSql();
            if (selectCol instanceof KeyWordCondition) {
                selectB.append(sql);
                continue;
            }
            selectB.append(selectCol.getDelimiter());
            selectB.append(sql);
        }
    }
}

