/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.filter;

import com.javaoffers.brief.modelhelper.filter.JqlExecutorChain;
import com.javaoffers.brief.modelhelper.filter.JqlExecutorFilter;
import com.javaoffers.brief.modelhelper.filter.JqlMetaInfo;
import com.javaoffers.brief.modelhelper.log.JqlLogger;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import java.util.List;

public class SmartJqlChainFilter
implements JqlExecutorFilter {
    public Object filter(JqlExecutorChain chain) {
        long cost = 0L;
        JqlMetaInfo jqlMetaInfo = chain.getJqlMetaInfo();
        TableInfo tableInfo = jqlMetaInfo.getTableInfo();
        DBType dbType = tableInfo.getDbType();
        jqlMetaInfo.getParams().parallelStream().flatMap(stringObjectMap -> stringObjectMap.entrySet().stream()).forEach(entry -> entry.setValue(dbType.processingTranslation(jqlMetaInfo, (String)entry.getKey(), entry.getValue())));
        JqlLogger.infoSql("SQL: {}", jqlMetaInfo.getSql());
        JqlLogger.infoSql("PAM: {}", jqlMetaInfo.getParams());
        long startTime = System.currentTimeMillis();
        Object o = chain.doChain();
        long endTime = System.currentTimeMillis();
        cost = endTime - startTime;
        if (cost > JqlLogger.time) {
            if (o instanceof List) {
                JqlLogger.infoSqlCost("COST TIME : {}, SIZE: {}", cost, ((List)o).size());
            } else {
                JqlLogger.infoSqlCost("COST TIME : {}", cost);
            }
        }
        return o;
    }
}

