/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.condition.insert;

import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.condition.insert.InsertCondition;
import com.javaoffers.brief.modelhelper.utils.ModelInfo;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InsertAllColValueCondition
implements InsertCondition {
    private Object model;
    private Class modelClass;
    private String sqlColNames;
    private String sqlValues;
    private HashMap<String, Object> param = new LinkedHashMap<String, Object>();
    private StringBuilder onDuplicate = new StringBuilder();
    private List<String> expressionColNames;
    private ModelInfo modelInfo;

    public ConditionTag getConditionTag() {
        return ConditionTag.VALUES;
    }

    public String getSql() {
        return this.sqlColNames;
    }

    public Map<String, Object> getParams() {
        return this.param;
    }

    @Override
    public String getValuesSql() {
        return this.sqlValues;
    }

    public InsertAllColValueCondition(Class modelClass, Object model) {
        this.model = model;
        this.modelClass = modelClass;
    }

    public void init(boolean isDuplicate) {
        this.gkeyProcess();
        this.parseParams();
        this.parseInsertSql();
        if (isDuplicate) {
            this.parseDupInsertSql();
        }
    }

    public void parseInsertSql() {
        Set<String> colNamesSet = this.getParams().keySet();
        String quote = TableHelper.getTableInfo((Class)this.modelClass).getDbType().getQuote();
        this.expressionColNames = this.getParams().keySet().stream().map(colName -> quote + colName + quote).collect(Collectors.toList());
        this.sqlColNames = ConditionTag.LK.getTag() + String.join((CharSequence)ConditionTag.COMMA.getTag(), this.expressionColNames) + ConditionTag.RK.getTag();
        StringBuilder valuesAppender = new StringBuilder(ConditionTag.LK.getTag());
        LinkedList<String> colNames = new LinkedList<String>();
        for (String colName2 : colNamesSet) {
            colNames.add("#{" + colName2 + "}");
        }
        valuesAppender.append(String.join((CharSequence)ConditionTag.COMMA.getTag(), colNames));
        valuesAppender.append(ConditionTag.RK.getTag());
        this.sqlValues = valuesAppender.toString();
    }

    public void parseDupInsertSql() {
        this.onDuplicate.append(ConditionTag.ON_DUPLICATE_KEY_UPDATE.getTag());
        String comma = ConditionTag.BLANK.getTag();
        for (String colName : this.expressionColNames) {
            this.onDuplicate.append(comma);
            this.onDuplicate.append(colName);
            this.onDuplicate.append(" = values(");
            this.onDuplicate.append(colName);
            this.onDuplicate.append(")");
            if (!StringUtils.isBlank((CharSequence)comma)) continue;
            comma = ConditionTag.COMMA.getTag();
        }
    }

    public void parseParams() {
        Map colAllAndFieldOnly = TableHelper.getOriginalColAllAndFieldOnly((Class)this.modelClass);
        colAllAndFieldOnly.forEach((colName, fields) -> {
            try {
                Object oValue = null;
                for (int i = 0; i < fields.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    Object o = field.get(this.model);
                    if (o == null) continue;
                    oValue = o;
                    break;
                }
                if (oValue != null) {
                    this.param.put((String)colName, oValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void gkeyProcess() {
        this.modelInfo = TableHelper.getModelInfo((Class)this.modelClass);
        List gkeyUniqueModels = this.modelInfo.getGkeyUniqueModels();
        if (CollectionUtils.isNotEmpty((Collection)gkeyUniqueModels)) {
            gkeyUniqueModels.forEach(gkeyUniqueModel -> {
                Object uniqueValue = gkeyUniqueModel.getGetter().getter(this.model);
                if (uniqueValue == null || uniqueValue instanceof Number && uniqueValue.toString().equals("0")) {
                    uniqueValue = gkeyUniqueModel.getUniqueKeyGenerate().generate();
                    gkeyUniqueModel.getSetter().setter(this.model, uniqueValue);
                }
            });
        }
    }

    public StringBuilder getOnDuplicate() {
        return this.onDuplicate;
    }

    public String getOnDuplicateString() {
        return this.onDuplicate.toString();
    }

    public Object getModel() {
        return this.model;
    }

    public Class getModelClass() {
        return this.modelClass;
    }

    public void setModel(Object model) {
        this.model = model;
    }

    public void setModelClass(Class modelClass) {
        this.modelClass = modelClass;
    }

    public void setSqlColNames(String sqlColNames) {
        this.sqlColNames = sqlColNames;
    }

    public void setSqlValues(String sqlValues) {
        this.sqlValues = sqlValues;
    }

    public void setParam(HashMap<String, Object> param) {
        this.param = param;
    }

    public void setOnDuplicate(StringBuilder onDuplicate) {
        this.onDuplicate = onDuplicate;
    }

    public void setExpressionColNames(List<String> expressionColNames) {
        this.expressionColNames = expressionColNames;
    }

    public String getSqlColNames() {
        return this.sqlColNames;
    }

    public String getSqlValues() {
        return this.sqlValues;
    }

    public List<String> getExpressionColNames() {
        return this.expressionColNames;
    }
}

