/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.condition.where;

import com.javaoffers.brief.modelhelper.fun.AggTag;
import com.javaoffers.brief.modelhelper.fun.CategoryTag;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.HashMap;
import java.util.Map;

public class HavingGroupCondition<V>
extends WhereOnCondition {
    private String colName;
    private ConditionTag tag;
    private V value;
    private AggTag aggTag;
    private Map<String, Object> params = new HashMap<String, Object>();

    public HavingGroupCondition() {
    }

    @Override
    public String getColName() {
        return this.colName;
    }

    @Override
    public ConditionTag getConditionTag() {
        return this.tag;
    }

    @Override
    public String getSql() {
        long idx = this.getNextLong();
        this.params.put(idx + "", this.value);
        if (this.aggTag != null) {
            return this.aggTag.name() + "(" + this.colName + ") " + this.tag.getTag() + " #{" + idx + "}";
        }
        return this.colName + " " + this.tag.getTag() + " #{" + idx + "}";
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    public HavingGroupCondition(AggTag aggTag, GetterFun colName, V value, ConditionTag tag) {
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        this.colName = TableHelper.getColNameNotAs((GetterFun)colName);
        this.tag = tag;
        this.aggTag = aggTag;
        this.value = value;
    }

    public HavingGroupCondition(AggTag aggTag, GetterFun[] colNames, V value, ConditionTag tag) {
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        StringBuilder cls = new StringBuilder();
        int i = 0;
        for (GetterFun colName : colNames) {
            if (i != 0) {
                cls.append(",");
            }
            ++i;
            cls.append(TableHelper.getColNameNotAs((GetterFun)colName));
        }
        this.colName = cls.toString();
        this.tag = tag;
        this.aggTag = aggTag;
        this.value = value;
    }
}

