/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.condition.where;

import com.javaoffers.brief.modelhelper.fun.AggTag;
import com.javaoffers.brief.modelhelper.fun.CategoryTag;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HavingInCondition<V>
extends WhereOnCondition
implements Condition {
    private String colName;
    private List<V> value;
    private ConditionTag tag;
    private Map<String, Object> param = new HashMap<String, Object>();
    private AggTag aggTag;

    @Override
    public String getColName() {
        return this.colName;
    }

    public List<V> getColValue() {
        return this.value;
    }

    @Override
    public ConditionTag getConditionTag() {
        return this.tag;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder();
        if (this.aggTag != null) {
            sql.append(this.aggTag.name());
            sql.append("(");
            sql.append(this.colName);
            sql.append(")");
        } else {
            sql.append(this.colName);
        }
        sql.append(this.tag.getTag());
        sql.append(" (");
        for (int i = 0; this.value != null && i < this.value.size(); ++i) {
            long idx = this.getNextLong();
            this.getParams().put(idx + "", this.value.get(i));
            sql.append("#{");
            sql.append(idx);
            sql.append("}");
            if (i + 1 == this.value.size()) continue;
            sql.append(",");
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public Map<String, Object> getParams() {
        return this.param;
    }

    public HavingInCondition(AggTag aggTag, GetterFun colName, Object[] value, ConditionTag tag) {
        super(colName, value, tag);
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        this.colName = TableHelper.getColNameNotAs((GetterFun)colName);
        this.value = new ArrayList<V>();
        for (Object v : value) {
            if (v instanceof Collection) {
                this.value.addAll((Collection)v);
                continue;
            }
            if (v.getClass().isArray()) {
                for (Object vv : (Object[])v) {
                    this.value.add(vv);
                }
                continue;
            }
            this.value.add(v);
        }
        this.tag = tag;
        this.aggTag = aggTag;
    }
}

