/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.condition.where;

import com.javaoffers.brief.modelhelper.fun.CategoryTag;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InCondition<V>
extends WhereOnCondition
implements Condition {
    private String colName;
    private List<V> value;
    private ConditionTag tag;
    private Map<String, Object> param = new HashMap<String, Object>();

    @Override
    public String getColName() {
        return this.colName;
    }

    public List<V> getColValue() {
        return this.value;
    }

    @Override
    public ConditionTag getConditionTag() {
        return this.tag;
    }

    @Override
    public String getSql() {
        int i;
        StringBuilder sql = new StringBuilder(this.colName);
        sql.append(this.tag.getTag());
        sql.append(" (");
        if (this.value != null && i < this.value.size()) {
            for (i = 0; i < this.value.size(); ++i) {
                long idx = this.getNextLong();
                this.getParams().put(idx + "", this.value.get(i));
                sql.append("#{");
                sql.append(idx);
                sql.append("}");
                if (i + 1 == this.value.size()) continue;
                sql.append(",");
            }
        } else {
            sql.append(" null ");
        }
        sql.append(") ");
        return sql.toString();
    }

    @Override
    public Map<String, Object> getParams() {
        return this.param;
    }

    public InCondition(GetterFun colName, Object[] value, ConditionTag tag) {
        super(colName, value, tag);
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        this.colName = TableHelper.getColNameNotAs((GetterFun)colName);
        this.value = new ArrayList<V>();
        for (Object v : value) {
            if (v instanceof Collection) {
                this.value.addAll((Collection)v);
                continue;
            }
            if (v.getClass().isArray()) {
                for (Object vv : (Object[])v) {
                    this.value.add(vv);
                }
                continue;
            }
            this.value.add(v);
        }
        this.tag = tag;
    }

    @Override
    public String toString() {
        return "WhereOnCondition{colName='" + this.colName + '\'' + ", value=" + this.value.toString() + ", tag=" + this.tag + '}';
    }
}

