/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.condition.where;

import com.javaoffers.brief.modelhelper.fun.CategoryTag;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereCondition;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.HashMap;
import java.util.Map;

public class WhereOnCondition<V>
implements WhereCondition {
    private String colName;
    private V value;
    private ConditionTag tag;
    private Map<String, Object> params = new HashMap<String, Object>();
    private HeadCondition headCondition;
    private String andOrTag = " and ";

    public WhereOnCondition() {
    }

    public void setColName(String colName) {
        this.colName = colName;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public ConditionTag getTag() {
        return this.tag;
    }

    public void setTag(ConditionTag tag) {
        this.tag = tag;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public HeadCondition getHeadCondition() {
        return this.headCondition;
    }

    public String getColName() {
        return this.colName;
    }

    public V getColValue() {
        return this.value;
    }

    public ConditionTag getConditionTag() {
        return this.tag;
    }

    public String getSql() {
        String colNameTag = this.getNextTag();
        this.params.put(colNameTag + "", this.value);
        return this.colName + " " + this.tag.getTag() + " #{" + colNameTag + "}";
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public WhereOnCondition(GetterFun colName, V value, ConditionTag tag) {
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        this.colName = TableHelper.getColNameNotAs((GetterFun)colName);
        this.value = value;
        this.tag = tag;
    }

    public WhereOnCondition(GetterFun[] colNames, V value, ConditionTag tag) {
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        StringBuilder cls = new StringBuilder();
        int i = 0;
        for (GetterFun colName : colNames) {
            if (i != 0) {
                cls.append(", ");
            }
            ++i;
            String colNameStr = TableHelper.getColNameNotAs((GetterFun)colName);
            cls.append(colNameStr);
        }
        this.colName = cls.toString();
        this.value = value;
        this.tag = tag;
    }

    public WhereOnCondition(String[] colNames, V value, ConditionTag tag) {
        Assert.isTrue((tag.getCategoryTag() == CategoryTag.WHERE_ON ? 1 : 0) != 0);
        StringBuilder cls = new StringBuilder();
        for (String colName : colNames) {
            if (cls.length() != 0) {
                cls.append(", ");
            }
            cls.append(colName);
        }
        this.colName = cls.toString();
        this.value = value;
        this.tag = tag;
    }

    @Override
    public void setHeadCondition(HeadCondition headCondition) {
        this.headCondition = headCondition;
    }

    @Override
    public void setAndOrTag(String andOrTag) {
        this.andOrTag = andOrTag;
    }

    @Override
    public String getAndOrTag() {
        return this.andOrTag;
    }

    @Override
    public long getNextLong() {
        Assert.isTrue((this.headCondition != null ? 1 : 0) != 0, (String)"head condition is null ");
        return this.headCondition.getNextLong();
    }

    @Override
    public String getNextTag() {
        return this.getNextLong() + "";
    }

    @Override
    public void cleanAndOrTag() {
        this.andOrTag = "";
    }

    public String toString() {
        return "WhereOnCondition{colName='" + this.colName + '\'' + ", value=" + this.value + ", tag=" + this.tag + '}';
    }
}

