/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.fun.AggTag;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.JoinTableCondition;
import com.javaoffers.brief.modelhelper.fun.condition.select.SelectColumnCondition;
import com.javaoffers.brief.modelhelper.fun.crud.JoinFun;
import com.javaoffers.brief.modelhelper.fun.crud.OnFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.OnFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class JoinFunmpl<M1, M2, V>
implements JoinFun<M1, M2, GetterFun<M2, Object>, V> {
    private LinkedList<Condition> conditions;
    private Class<M1> m1Class;
    private Class<M2> m2Class;
    private String table2Name;

    public JoinFunmpl(Class<M1> mc, Class<M2> m2c, LinkedList<Condition> conditions, ConditionTag tag) {
        this.m1Class = mc;
        this.m2Class = m2c;
        this.conditions = conditions;
        this.table2Name = TableHelper.getTableName(m2c);
        this.conditions.add(new JoinTableCondition(this.table2Name, tag));
    }

    @Override
    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(String ... colSql) {
        Stream.of(colSql).forEach(col -> this.conditions.add(new SelectColumnCondition((String)col)));
        return this;
    }

    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(GetterFun<M2, Object> ... cols) {
        Stream.of(cols).forEach(col -> this.conditions.add(new SelectColumnCondition((GetterFun)col)));
        return this;
    }

    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(boolean condition, GetterFun<M2, Object> ... cols) {
        if (condition) {
            this.col(cols);
        }
        return this;
    }

    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(AggTag aggTag, GetterFun<M2, Object> ... cols) {
        Stream.of(cols).forEach(col -> {
            Pair colAgg = TableHelper.getSelectAggrColStatement((GetterFun)col);
            this.conditions.add(new SelectColumnCondition(aggTag.name() + "(" + (String)colAgg.getLeft() + ") as " + (String)colAgg.getRight()));
        });
        return this;
    }

    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(boolean condition, AggTag aggTag, GetterFun<M2, Object> ... col) {
        if (condition) {
            this.col(aggTag, col);
        }
        return this;
    }

    @Override
    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(AggTag aggTag, GetterFun<M2, Object> col, String asName) {
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(col);
        String colName = (String)colNameAndAliasName.getLeft();
        this.conditions.add(new SelectColumnCondition(aggTag.name() + "(" + colName + ") as " + this.m2Class.getSimpleName() + asName));
        return this;
    }

    @Override
    public JoinFun<M1, M2, GetterFun<M2, Object>, V> col(boolean condition, AggTag aggTag, GetterFun<M2, Object> col, String asName) {
        if (condition) {
            this.col(aggTag, col, asName);
        }
        return this;
    }

    @Override
    public JoinFun<M1, M2, GetterFun<M2, Object>, V> colAll() {
        List colAll = TableHelper.getColAllForSelect(this.m2Class, SelectColumnCondition::new);
        this.conditions.addAll(colAll);
        return this;
    }

    @Override
    public <C1 extends GetterFun<M1, Object>> OnFun<M1, M2, V, ?> on() {
        return new OnFunImpl(this.m1Class, this.m2Class, this.conditions);
    }
}

