/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.fun.AggTag;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.JoinTableCondition;
import com.javaoffers.brief.modelhelper.fun.condition.select.SelectColumnCondition;
import com.javaoffers.brief.modelhelper.fun.crud.LastJoinFun;
import com.javaoffers.brief.modelhelper.fun.crud.LastOnFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.LastOnFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class LastJoinFunImpl<M1, M2, M3, C3 extends GetterFun<M3, Object>, V>
implements LastJoinFun<M1, M2, M3, C3, V> {
    private LinkedList<Condition> conditions;
    private Class<M1> m1Class;
    private Class<M2> m2Class;
    private Class<M3> m3Class;
    private String table3Name;

    public LastJoinFunImpl(Class<M1> m1Class, Class<M2> m2Class, Class<M3> m3Class, LinkedList<Condition> conditions, ConditionTag tag) {
        this.conditions = conditions;
        this.m1Class = m1Class;
        this.m2Class = m2Class;
        this.m3Class = m3Class;
        this.table3Name = TableHelper.getTableName(m3Class);
        this.conditions.add(new JoinTableCondition(this.table3Name, tag));
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(C3 ... cols) {
        Stream.of(cols).forEach(col -> this.conditions.add(new SelectColumnCondition((GetterFun)col)));
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(boolean condition, C3 ... cols) {
        if (condition) {
            this.col((GetterFun[])cols);
        }
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(AggTag aggTag, C3 ... cols) {
        Stream.of(cols).forEach(col -> {
            Pair colAgg = TableHelper.getSelectAggrColStatement((GetterFun)col);
            this.conditions.add(new SelectColumnCondition(aggTag.name() + "(" + (String)colAgg.getLeft() + ") as " + (String)colAgg.getRight()));
        });
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(boolean condition, AggTag aggTag, C3 ... cols) {
        if (condition) {
            this.col(aggTag, (GetterFun[])cols);
        }
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(AggTag aggTag, C3 col, String asName) {
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(col);
        String colName = (String)colNameAndAliasName.getLeft();
        this.conditions.add(new SelectColumnCondition(aggTag.name() + "(" + colName + ") as " + this.m3Class.getSimpleName() + asName));
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(boolean condition, AggTag aggTag, C3 col, String asName) {
        if (condition) {
            this.col(aggTag, col, asName);
        }
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> colAll() {
        List colAll = TableHelper.getColAllForSelect(this.m3Class, SelectColumnCondition::new);
        this.conditions.addAll(colAll);
        return this;
    }

    @Override
    public LastJoinFun<M1, M2, M3, C3, V> col(String ... colSql) {
        Stream.of(colSql).forEach(col -> this.conditions.add(new SelectColumnCondition((String)col)));
        return this;
    }

    @Override
    public <C2 extends GetterFun<M2, Object>> LastOnFun<M1, M2, M3, C2, C3, V> on() {
        return new LastOnFunImpl(this.conditions);
    }
}

