/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GGetterFun;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.condition.where.BetweenCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.CondSQLCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.ExistsCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.GroupByWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.InCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.IsNullOrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LFCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LikeCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LimitWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrderWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.RFWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import com.javaoffers.brief.modelhelper.fun.crud.LeftWhereSelectFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.LeftHavingPendingFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.WhereSelectFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class LeftWhereSelectFunImpl<M, M2, V, R extends LeftWhereSelectFunImpl<M, M2, V, R>>
implements LeftWhereSelectFun<M, M2, GetterFun<M, V>, GGetterFun<M2, V>, V, R> {
    private LinkedList<Condition> conditions;
    private WhereSelectFunImpl whereSelectFun;

    public LeftWhereSelectFunImpl(LinkedList<Condition> conditions) {
        this.conditions = conditions;
        this.whereSelectFun = new WhereSelectFunImpl(this.conditions);
    }

    @Override
    public M ex() {
        List<M> exs = this.exs();
        if (exs == null || exs.size() == 0) {
            return null;
        }
        return exs.get(0);
    }

    @Override
    public R or() {
        this.conditions.add(new OrCondition());
        return (R)this;
    }

    @Override
    public R unite(Consumer<R> r) {
        this.conditions.add(new LFCondition(ConditionTag.LK));
        r.accept(this);
        this.conditions.add(new RFWordCondition(ConditionTag.RK));
        return (R)this;
    }

    @Override
    public R unite(boolean condition, Consumer<R> r) {
        if (condition) {
            this.unite((Consumer)r);
        }
        return (R)this;
    }

    @Override
    public R condSQL(String sql) {
        this.conditions.add(new CondSQLCondition(sql));
        return (R)this;
    }

    @Override
    public R condSQL(boolean condition, String sql) {
        if (condition) {
            this.condSQL(sql);
        }
        return (R)this;
    }

    @Override
    public R condSQL(String sql, Map<String, Object> params) {
        this.conditions.add(new CondSQLCondition(sql, params));
        return (R)this;
    }

    @Override
    public R condSQL(boolean condition, String sql, Map<String, Object> params) {
        if (condition) {
            this.condSQL(sql, (Map)params);
        }
        return (R)this;
    }

    public R orderA(GetterFun<M, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, true));
        return (R)this;
    }

    public R orderA(boolean condition, GetterFun<M, V> ... getterFuns) {
        if (condition) {
            this.orderA(getterFuns);
        }
        return (R)this;
    }

    public R orderD(GetterFun<M, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, false));
        return (R)this;
    }

    public R orderD(boolean condition, GetterFun<M, V> ... getterFuns) {
        if (condition) {
            this.orderD(getterFuns);
        }
        return (R)this;
    }

    @Override
    public R orderA(GGetterFun<M2, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, true));
        return (R)this;
    }

    @Override
    public R orderA(boolean condition, GGetterFun<M2, V> ... getterFuns) {
        if (condition) {
            this.orderA((GGetterFun[])getterFuns);
        }
        return (R)this;
    }

    @Override
    public R orderD(GGetterFun<M2, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, false));
        return (R)this;
    }

    @Override
    public R orderD(boolean condition, GGetterFun<M2, V> ... getterFuns) {
        if (condition) {
            this.orderD((GGetterFun[])getterFuns);
        }
        return (R)this;
    }

    @Override
    public R eq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.EQ));
        return (R)this;
    }

    @Override
    public R eq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.eq(col, value);
        }
        return (R)this;
    }

    @Override
    public R ueq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.UEQ));
        return (R)this;
    }

    @Override
    public R ueq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.ueq(col, value);
        }
        return (R)this;
    }

    @Override
    public R gt(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.GT));
        return (R)this;
    }

    @Override
    public R gt(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.gt(col, value);
        }
        return (R)this;
    }

    @Override
    public R lt(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.LT));
        return (R)this;
    }

    @Override
    public R lt(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.lt(col, value);
        }
        return (R)this;
    }

    @Override
    public R gtEq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.GT_EQ));
        return (R)this;
    }

    @Override
    public R gtEq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.gtEq(col, value);
        }
        return (R)this;
    }

    @Override
    public R ltEq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.LT_EQ));
        return (R)this;
    }

    @Override
    public R ltEq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.ltEq(col, value);
        }
        return (R)this;
    }

    @Override
    public R between(GetterFun<M, V> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.BETWEEN));
        return (R)this;
    }

    @Override
    public R between(boolean condition, GetterFun<M, V> col, V start, V end) {
        if (condition) {
            this.between(col, start, end);
        }
        return (R)this;
    }

    @Override
    public R notBetween(GetterFun<M, V> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.NOT_BETWEEN));
        return (R)this;
    }

    @Override
    public R notBetween(boolean condition, GetterFun<M, V> col, V start, V end) {
        if (condition) {
            this.notBetween(col, start, end);
        }
        return (R)this;
    }

    @Override
    public R like(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE));
        return (R)this;
    }

    @Override
    public R like(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.like(col, value);
        }
        return (R)this;
    }

    @Override
    public R likeLeft(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_LEFT));
        return (R)this;
    }

    @Override
    public R likeLeft(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.likeLeft(col, value);
        }
        return (R)this;
    }

    @Override
    public R likeRight(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_RIGHT));
        return (R)this;
    }

    @Override
    public R likeRight(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.likeRight(col, value);
        }
        return (R)this;
    }

    @Override
    public R in(GetterFun<M, V> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.IN));
        return (R)this;
    }

    @Override
    public R in(boolean condition, GetterFun<M, V> col, V ... values) {
        if (condition) {
            this.in(col, values);
        }
        return (R)this;
    }

    @Override
    public R in(GetterFun<M, V> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.IN));
        return (R)this;
    }

    @Override
    public R in(boolean condition, GetterFun<M, V> col, Collection ... values) {
        if (condition) {
            this.in(col, values);
        }
        return (R)this;
    }

    @Override
    public R notIn(GetterFun<M, V> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.NOT_IN));
        return (R)this;
    }

    @Override
    public R notIn(boolean condition, GetterFun<M, V> col, V ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return (R)this;
    }

    @Override
    public R notIn(GetterFun<M, V> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.NOT_IN));
        return (R)this;
    }

    @Override
    public R notIn(boolean condition, GetterFun<M, V> col, Collection ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return (R)this;
    }

    public R isNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NULL));
        }
        return (R)this;
    }

    public R isNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return (R)this;
    }

    public R isNotNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NOT_NULL));
        }
        return (R)this;
    }

    public R isNotNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return (R)this;
    }

    public R exists(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new ExistsCondition(col));
        }
        return (R)this;
    }

    public R exists(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.exists(cols);
        }
        return (R)this;
    }

    public LeftHavingPendingFunImpl<M, M2, GetterFun<M, V>, GGetterFun<M2, V>, V, V> groupBy(GetterFun<M, V> ... c) {
        this.conditions.add(new GroupByWordCondition(c, ConditionTag.GROUP_BY));
        return new LeftHavingPendingFunImpl(this.conditions);
    }

    public LeftHavingPendingFunImpl<M, M2, GetterFun<M, V>, GGetterFun<M2, V>, V, V> groupBy(GGetterFun<M2, V> ... c) {
        this.conditions.add(new GroupByWordCondition((GetterFun[])c, ConditionTag.GROUP_BY));
        return new LeftHavingPendingFunImpl(this.conditions);
    }

    @Override
    public R limitPage(int pageNum, int size) {
        this.conditions.add(new LimitWordCondition(pageNum, size));
        return (R)this;
    }

    @Override
    public List<M> exs() {
        return this.whereSelectFun.exs();
    }

    @Override
    public void stream(Consumer<M> consumer) {
        this.whereSelectFun.stream(consumer);
    }
}

