/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.ConstructorFun;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.mark.OnConditionMark;
import com.javaoffers.brief.modelhelper.fun.condition.on.OnColumnFunCondition;
import com.javaoffers.brief.modelhelper.fun.condition.on.OnValueFunCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.BetweenCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.CondSQLCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.ExistsCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.InCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.IsNullOrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LFCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LikeCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.RFWordCondition;
import com.javaoffers.brief.modelhelper.fun.crud.LastJoinFun;
import com.javaoffers.brief.modelhelper.fun.crud.OnFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.LastJoinFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.LeftWhereSelectFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.WhereSelectFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.sql.DataSource;

public class OnFunImpl<M1, M2, V>
implements OnFun<M1, M2, V, OnFunImpl<M1, M2, V>> {
    private LinkedList<Condition> conditions;
    private WhereSelectFunImpl<M1, V> whereSelectFun;
    private Class<M2> m1Class;
    private Class<M2> m2Class;

    public OnFunImpl(Class<M2> m1Class, Class<M2> m2Class, LinkedList<Condition> conditions) {
        this.conditions = conditions;
        this.conditions.add(new OnConditionMark());
        this.whereSelectFun = new WhereSelectFunImpl(conditions, false);
        this.m2Class = m2Class;
        this.m1Class = m1Class;
    }

    @Override
    public M1 ex() {
        return this.whereSelectFun.ex();
    }

    @Override
    public List<M1> exs() {
        return this.whereSelectFun.exs();
    }

    @Override
    public OnFunImpl<M1, M2, V> oeq(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.EQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> oueq(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.UEQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ogt(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.GT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> olt(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.LT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ogtEq(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.GT_EQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> oltEq(GetterFun<M1, Object> col, GetterFun<M2, Object> col2) {
        this.conditions.add(new OnColumnFunCondition(col, col2, ConditionTag.LT_EQ));
        return this;
    }

    @Override
    public LeftWhereSelectFunImpl<M1, M2, V, ?> where() {
        return new LeftWhereSelectFunImpl(this.conditions);
    }

    @Override
    public OnFunImpl<M1, M2, V> or() {
        this.conditions.add(new OrCondition());
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> unite(Consumer<OnFunImpl<M1, M2, V>> r) {
        this.conditions.add(new LFCondition(ConditionTag.LK));
        r.accept(this);
        this.conditions.add(new RFWordCondition(ConditionTag.RK));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> unite(boolean condition, Consumer<OnFunImpl<M1, M2, V>> r) {
        if (condition) {
            this.unite((Consumer)r);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> condSQL(String sql) {
        this.conditions.add(new CondSQLCondition(sql));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> condSQL(boolean condition, String sql) {
        if (condition) {
            this.condSQL(sql);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> condSQL(String sql, Map<String, Object> params) {
        this.conditions.add(new CondSQLCondition(sql, params));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> condSQL(boolean condition, String sql, Map<String, Object> params) {
        if (condition) {
            this.condSQL(sql, (Map)params);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> eq(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.EQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> eq(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.eq(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ueq(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.UEQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ueq(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.ueq(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> gt(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.GT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> gt(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.gt(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> lt(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.LT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> lt(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.lt(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> gtEq(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.GT_EQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> gtEq(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.gtEq(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ltEq(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new OnValueFunCondition((GetterFun)col, (Object)value, ConditionTag.LT_EQ));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> ltEq(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.ltEq(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> between(GetterFun<M2, Object> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.BETWEEN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> between(boolean condition, GetterFun<M2, Object> col, V start, V end) {
        if (condition) {
            this.between(col, start, end);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notBetween(GetterFun<M2, Object> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.NOT_BETWEEN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notBetween(boolean condition, GetterFun<M2, Object> col, V start, V end) {
        if (condition) {
            this.notBetween(col, start, end);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> like(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> like(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.like(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> likeLeft(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_LEFT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> likeLeft(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.likeLeft(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> likeRight(GetterFun<M2, Object> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_RIGHT));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> likeRight(boolean condition, GetterFun<M2, Object> col, V value) {
        if (condition) {
            this.likeRight(col, value);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> in(GetterFun<M2, Object> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.IN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> in(boolean condition, GetterFun<M2, Object> col, V ... values) {
        if (condition) {
            this.in(col, values);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> in(GetterFun<M2, Object> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.IN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> in(boolean condition, GetterFun<M2, Object> col, Collection ... values) {
        if (condition) {
            this.in(col, values);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notIn(GetterFun<M2, Object> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.NOT_IN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notIn(boolean condition, GetterFun<M2, Object> col, V ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notIn(GetterFun<M2, Object> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.NOT_IN));
        return this;
    }

    @Override
    public OnFunImpl<M1, M2, V> notIn(boolean condition, GetterFun<M2, Object> col, Collection ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> isNull(GetterFun<M2, Object> ... cols) {
        for (GetterFun<M2, Object> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NULL));
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> isNull(boolean condition, GetterFun<M2, Object> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> isNotNull(GetterFun<M2, Object> ... cols) {
        for (GetterFun<M2, Object> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NOT_NULL));
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> isNotNull(boolean condition, GetterFun<M2, Object> ... cols) {
        if (condition) {
            this.isNotNull(cols);
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> exists(GetterFun<M2, Object> ... cols) {
        for (GetterFun<M2, Object> col : cols) {
            this.conditions.add(new ExistsCondition(col));
        }
        return this;
    }

    public OnFunImpl<M1, M2, V> exists(boolean condition, GetterFun<M2, Object> ... cols) {
        if (condition) {
            this.exists(cols);
        }
        return this;
    }

    @Override
    public <M3, C3 extends GetterFun<M3, Object>> LastJoinFun<M1, M2, M3, C3, V> leftJoin(ConstructorFun<M3> m3) {
        HeadCondition headCondition = (HeadCondition)this.conditions.peekFirst();
        return new LastJoinFunImpl(this.m1Class, this.m2Class, TableHelper.getClassFromConstructorFunForJoin(m3, (DataSource)headCondition.getDataSource()), this.conditions, ConditionTag.LEFT_JOIN);
    }

    @Override
    public <M3, C3 extends GetterFun<M3, Object>> LastJoinFun<M1, M2, M3, C3, V> innerJoin(ConstructorFun<M3> m3) {
        HeadCondition headCondition = (HeadCondition)this.conditions.peekFirst();
        return new LastJoinFunImpl(this.m1Class, this.m2Class, TableHelper.getClassFromConstructorFunForJoin(m3, (DataSource)headCondition.getDataSource()), this.conditions, ConditionTag.INNER_JOIN);
    }

    @Override
    public <M3, C3 extends GetterFun<M3, Object>> LastJoinFun<M1, M2, M3, C3, V> rightJoin(ConstructorFun<M3> m3) {
        HeadCondition headCondition = (HeadCondition)this.conditions.peekFirst();
        return new LastJoinFunImpl(this.m1Class, this.m2Class, TableHelper.getClassFromConstructorFunForJoin(m3, (DataSource)headCondition.getDataSource()), this.conditions, ConditionTag.RIGHT_JOIN);
    }

    @Override
    public void stream(Consumer<M1> consumer) {
        this.whereSelectFun.stream(consumer);
    }
}

