/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.core.CrudMapperMethodThreadLocal;
import com.javaoffers.brief.modelhelper.core.LinkedConditions;
import com.javaoffers.brief.modelhelper.fun.AggTag;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.KeyWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.select.SelectTableCondition;
import com.javaoffers.brief.modelhelper.fun.crud.SelectFun;
import com.javaoffers.brief.modelhelper.fun.crud.SmartSelectFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.SmartSelectFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;

public class SelectFunImpl<M>
implements SelectFun<M, GetterFun<M, Object>, Object> {
    private Class<M> mClass;
    private LinkedConditions<Condition> conditions = new LinkedConditions();
    private SmartSelectFunImpl<M, GetterFun<M, Object>, Object> smartSelectFun;

    public SelectFunImpl(Class<M> mClass) {
        this.conditions.add(new HeadCondition(CrudMapperMethodThreadLocal.getExcutorDataSource(), mClass));
        this.conditions.add(new SelectTableCondition(TableHelper.getTableName(mClass), mClass));
        this.mClass = mClass;
        this.smartSelectFun = new SmartSelectFunImpl(mClass, this.conditions);
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> distinct() {
        this.conditions.add(new KeyWordCondition(ConditionTag.DISTINCT.getTag()));
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(GetterFun col) {
        this.smartSelectFun.col(col);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(GetterFun ... cols) {
        this.smartSelectFun.col((GetterFun<M, Object>)cols);
        return this.smartSelectFun;
    }

    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(boolean condition, GetterFun<M, Object> ... cols) {
        this.smartSelectFun.col(condition, cols);
        return this.smartSelectFun;
    }

    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(AggTag aggTag, GetterFun<M, Object> ... cols) {
        this.smartSelectFun.col(aggTag, cols);
        return this.smartSelectFun;
    }

    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(boolean condition, AggTag aggTag, GetterFun<M, Object> ... cols) {
        this.smartSelectFun.col(condition, aggTag, cols);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(AggTag aggTag, GetterFun<M, Object> col, String asName) {
        this.smartSelectFun.col(aggTag, col, asName);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(boolean condition, AggTag aggTag, GetterFun<M, Object> col, String asName) {
        this.smartSelectFun.col(condition, aggTag, col, asName);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(String ... colSql) {
        this.smartSelectFun.col(colSql);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> col(boolean condition, String ... colSql) {
        this.smartSelectFun.col(condition, colSql);
        return this.smartSelectFun;
    }

    @Override
    public SmartSelectFun<M, GetterFun<M, Object>, Object> colAll() {
        this.smartSelectFun.colAll();
        return this.smartSelectFun;
    }
}

