/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl;

import com.javaoffers.brief.modelhelper.core.BaseBrief;
import com.javaoffers.brief.modelhelper.core.BaseBriefImpl;
import com.javaoffers.brief.modelhelper.core.BaseSQLStatement;
import com.javaoffers.brief.modelhelper.core.StatementParserAdepter;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.mark.WhereConditionMark;
import com.javaoffers.brief.modelhelper.fun.condition.where.BetweenCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.CondSQLCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.ExistsCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.GroupByWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.InCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.IsNullOrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LFCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LikeCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LimitWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.OrderWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.RFWordCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.WhereOnCondition;
import com.javaoffers.brief.modelhelper.fun.crud.HavingPendingFun;
import com.javaoffers.brief.modelhelper.fun.crud.WhereSelectFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.HavingPendingFunImpl;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class WhereSelectFunImpl<M, V>
implements WhereSelectFun<M, V> {
    private LinkedList<Condition> conditions;

    public WhereSelectFunImpl(LinkedList<Condition> conditions) {
        this.conditions = conditions;
        this.conditions.add(new WhereConditionMark());
    }

    public WhereSelectFunImpl(LinkedList<Condition> conditions, boolean isAddMark) {
        this.conditions = conditions;
        if (isAddMark) {
            this.conditions.add(new WhereConditionMark());
        }
    }

    @Override
    public WhereSelectFunImpl<M, V> or() {
        this.conditions.add(new OrCondition());
        return this;
    }

    @Override
    public WhereSelectFun<M, V> unite(Consumer<WhereSelectFun<M, V>> r) {
        this.conditions.add(new LFCondition(ConditionTag.LK));
        r.accept(this);
        this.conditions.add(new RFWordCondition(ConditionTag.RK));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> unite(boolean condition, Consumer<WhereSelectFun<M, V>> r) {
        if (condition) {
            this.unite((Consumer)r);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> condSQL(String sql) {
        this.conditions.add(new CondSQLCondition(sql));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> condSQL(boolean condition, String sql) {
        if (condition) {
            this.condSQL(sql);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> condSQL(String sql, Map<String, Object> params) {
        this.conditions.add(new CondSQLCondition(sql, params));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> condSQL(boolean condition, String sql, Map<String, Object> params) {
        if (condition) {
            this.condSQL(sql, (Map)params);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> eq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.EQ));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> eq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.eq(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> ueq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.UEQ));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> ueq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.ueq(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> gt(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.GT));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> gt(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.gt(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> lt(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.LT));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> lt(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.lt(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> gtEq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.GT_EQ));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> gtEq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.gtEq(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> ltEq(GetterFun<M, V> col, V value) {
        this.conditions.add(new WhereOnCondition<V>(col, value, ConditionTag.LT_EQ));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> ltEq(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.ltEq(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> between(GetterFun<M, V> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.BETWEEN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> between(boolean condition, GetterFun<M, V> col, V start, V end) {
        if (condition) {
            this.between(col, start, end);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notBetween(GetterFun<M, V> col, V start, V end) {
        this.conditions.add(new BetweenCondition<V>(col, start, end, ConditionTag.NOT_BETWEEN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notBetween(boolean condition, GetterFun<M, V> col, V start, V end) {
        if (condition) {
            this.notBetween(col, start, end);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> like(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> like(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.like(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> likeLeft(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_LEFT));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> likeLeft(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.likeLeft(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> likeRight(GetterFun<M, V> col, V value) {
        this.conditions.add(new LikeCondition((GetterFun)col, (Object)value, ConditionTag.LIKE_RIGHT));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> likeRight(boolean condition, GetterFun<M, V> col, V value) {
        if (condition) {
            this.likeRight(col, value);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> in(GetterFun<M, V> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.IN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> in(boolean condition, GetterFun<M, V> col, V ... values) {
        if (condition) {
            this.in(col, values);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> in(GetterFun<M, V> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.IN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> in(boolean condition, GetterFun<M, V> col, Collection ... values) {
        if (condition) {
            this.in(col, values);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notIn(GetterFun<M, V> col, V ... values) {
        this.conditions.add(new InCondition(col, values, ConditionTag.NOT_IN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notIn(boolean condition, GetterFun<M, V> col, V ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notIn(GetterFun<M, V> col, Collection ... values) {
        this.conditions.add(new InCondition((GetterFun)col, values, ConditionTag.NOT_IN));
        return this;
    }

    @Override
    public WhereSelectFun<M, V> notIn(boolean condition, GetterFun<M, V> col, Collection ... values) {
        if (condition) {
            this.notIn(col, values);
        }
        return this;
    }

    public WhereSelectFun<M, V> isNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NULL));
        }
        return this;
    }

    public WhereSelectFun<M, V> isNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return this;
    }

    public WhereSelectFun<M, V> isNotNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NOT_NULL));
        }
        return this;
    }

    public WhereSelectFun<M, V> isNotNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return this;
    }

    public WhereSelectFunImpl<M, V> exists(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new ExistsCondition(col));
        }
        return this;
    }

    public WhereSelectFun<M, V> exists(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.exists(cols);
        }
        return this;
    }

    @Override
    public M ex() {
        List<M> exs = this.exs();
        if (exs != null && exs.size() > 0) {
            return exs.get(0);
        }
        return null;
    }

    public HavingPendingFun<M, GetterFun<M, V>, V, ?> groupBy(GetterFun<M, V> ... c) {
        this.conditions.add(new GroupByWordCondition(c, ConditionTag.GROUP_BY));
        return new HavingPendingFunImpl(this.conditions);
    }

    @Override
    public HavingPendingFun<M, GetterFun<M, V>, V, ?> groupBy(String ... colSql) {
        this.conditions.add(new GroupByWordCondition(colSql, ConditionTag.GROUP_BY));
        return new HavingPendingFunImpl(this.conditions);
    }

    @Override
    public WhereSelectFun<M, V> limitPage(int pageNum, int size) {
        this.conditions.add(new LimitWordCondition(pageNum, size));
        return this;
    }

    public WhereSelectFun<M, V> orderA(GetterFun<M, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, true));
        return this;
    }

    public WhereSelectFun<M, V> orderA(boolean condition, GetterFun<M, V> ... getterFuns) {
        if (condition) {
            this.orderA(getterFuns);
        }
        return this;
    }

    public WhereSelectFun<M, V> orderD(GetterFun<M, V> ... getterFuns) {
        List<String> clos = Arrays.stream(getterFuns).map(getterFun -> {
            String cloName = (String)TableHelper.getColNameAndAliasName((GetterFun)getterFun).getLeft();
            return cloName;
        }).collect(Collectors.toList());
        this.conditions.add(new OrderWordCondition(ConditionTag.ORDER, clos, false));
        return this;
    }

    public WhereSelectFun<M, V> orderD(boolean condition, GetterFun<M, V> ... getterFuns) {
        if (condition) {
            this.orderD(getterFuns);
        }
        return this;
    }

    @Override
    public List<M> exs() {
        BaseBrief instance = BaseBriefImpl.getInstance((HeadCondition)this.conditions.peekFirst());
        BaseSQLStatement sqlStatement = StatementParserAdepter.statementParse(this.conditions);
        return instance.queryData(sqlStatement.getSql(), (Map)sqlStatement.getParams().get(0));
    }

    @Override
    public void stream(Consumer<M> consumer) {
        BaseBrief instance = BaseBriefImpl.getInstance((HeadCondition)this.conditions.peekFirst());
        BaseSQLStatement sqlStatement = StatementParserAdepter.statementParse(this.conditions);
        instance.queryStream(sqlStatement.getSql(), (Map)sqlStatement.getParams().get(0), consumer);
    }
}

