/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.crud.impl.update;

import com.javaoffers.brief.modelhelper.core.BaseBrief;
import com.javaoffers.brief.modelhelper.core.BaseBriefImpl;
import com.javaoffers.brief.modelhelper.core.LinkedConditions;
import com.javaoffers.brief.modelhelper.core.MoreSQLInfo;
import com.javaoffers.brief.modelhelper.core.SQLStatement;
import com.javaoffers.brief.modelhelper.core.StatementParserAdepter;
import com.javaoffers.brief.modelhelper.exception.UpdateFieldsException;
import com.javaoffers.brief.modelhelper.fun.Condition;
import com.javaoffers.brief.modelhelper.fun.ConditionTag;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.AddPatchMarkCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.CondSQLCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.IsNullOrCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.LFCondition;
import com.javaoffers.brief.modelhelper.fun.condition.where.RFWordCondition;
import com.javaoffers.brief.modelhelper.fun.crud.WhereModifyFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.WhereSelectFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.update.SmartUpdateFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.update.SmartUpdateFun;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class WhereModifyFunImpl<M, V>
implements WhereModifyFun<M, V> {
    private WhereSelectFunImpl whereFun;
    private LinkedConditions<Condition> conditions;
    private Class modelClass;
    private boolean isUpdateNull;

    public WhereModifyFunImpl(LinkedConditions<Condition> conditions, Class modelClass) {
        this.conditions = conditions;
        this.whereFun = new WhereSelectFunImpl(this.conditions);
        this.modelClass = modelClass;
    }

    @Override
    public WhereModifyFun<M, V> or() {
        this.whereFun.or();
        return this;
    }

    @Override
    public WhereModifyFun<M, V> unite(Consumer<WhereModifyFun<M, V>> r) {
        this.conditions.add(new LFCondition(ConditionTag.LK));
        r.accept(this);
        this.conditions.add(new RFWordCondition(ConditionTag.RK));
        return this;
    }

    @Override
    public WhereModifyFun<M, V> unite(boolean condition, Consumer<WhereModifyFun<M, V>> r) {
        if (condition) {
            this.unite((Consumer)r);
        }
        return this;
    }

    @Override
    public WhereModifyFun<M, V> condSQL(String sql) {
        this.conditions.add(new CondSQLCondition(sql));
        return this;
    }

    @Override
    public WhereModifyFun<M, V> condSQL(boolean condition, String sql) {
        if (condition) {
            this.condSQL(sql);
        }
        return this;
    }

    @Override
    public WhereModifyFun<M, V> condSQL(String sql, Map<String, Object> params) {
        this.conditions.add(new CondSQLCondition(sql, params));
        return this;
    }

    @Override
    public WhereModifyFun<M, V> condSQL(boolean condition, String sql, Map<String, Object> params) {
        if (condition) {
            this.condSQL(sql, (Map)params);
        }
        return this;
    }

    @Override
    public WhereModifyFun<M, V> eq(GetterFun<M, V> col, V value) {
        this.whereFun.eq(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> eq(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.eq(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> ueq(GetterFun<M, V> col, V value) {
        this.whereFun.ueq(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> ueq(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.ueq(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> gt(GetterFun<M, V> col, V value) {
        this.whereFun.gt(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> gt(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.gt(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> lt(GetterFun<M, V> col, V value) {
        this.whereFun.lt(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> lt(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.lt(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> gtEq(GetterFun<M, V> col, V value) {
        this.whereFun.gtEq(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> gtEq(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.gtEq(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> ltEq(GetterFun<M, V> col, V value) {
        this.whereFun.ltEq(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> ltEq(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.ltEq(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> between(GetterFun<M, V> col, V start, V end) {
        this.whereFun.between(col, start, end);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> between(boolean condition, GetterFun<M, V> col, V start, V end) {
        this.whereFun.between(condition, col, start, end);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notBetween(GetterFun<M, V> col, V start, V end) {
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notBetween(boolean condition, GetterFun<M, V> col, V start, V end) {
        return this;
    }

    @Override
    public WhereModifyFun<M, V> like(GetterFun<M, V> col, V value) {
        this.whereFun.like(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> like(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.like(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> likeLeft(GetterFun<M, V> col, V value) {
        this.whereFun.likeLeft(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> likeLeft(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.likeLeft(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> likeRight(GetterFun<M, V> col, V value) {
        this.whereFun.likeRight(col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> likeRight(boolean condition, GetterFun<M, V> col, V value) {
        this.whereFun.likeRight(condition, col, value);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> in(GetterFun<M, V> col, V ... values) {
        this.whereFun.in(col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> in(boolean condition, GetterFun<M, V> col, V ... values) {
        this.whereFun.in(condition, col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> in(GetterFun<M, V> col, Collection ... values) {
        this.whereFun.in(col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> in(boolean condition, GetterFun<M, V> col, Collection ... values) {
        this.whereFun.in(condition, col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notIn(GetterFun<M, V> col, V ... values) {
        this.whereFun.notIn(col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notIn(boolean condition, GetterFun<M, V> col, V ... values) {
        this.whereFun.notIn(condition, col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notIn(GetterFun<M, V> col, Collection ... values) {
        this.whereFun.notIn(col, values);
        return this;
    }

    @Override
    public WhereModifyFun<M, V> notIn(boolean condition, GetterFun<M, V> col, Collection ... values) {
        this.whereFun.notIn(condition, col, values);
        return this;
    }

    public WhereModifyFun<M, V> isNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NULL));
        }
        return this;
    }

    public WhereModifyFun<M, V> isNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNull(cols);
        }
        return this;
    }

    public WhereModifyFun<M, V> isNotNull(GetterFun<M, V> ... cols) {
        for (GetterFun<M, V> col : cols) {
            this.conditions.add(new IsNullOrCondition(col, ConditionTag.IS_NOT_NULL));
        }
        return this;
    }

    public WhereModifyFun<M, V> isNotNull(boolean condition, GetterFun<M, V> ... cols) {
        if (condition) {
            this.isNotNull(cols);
        }
        return this;
    }

    public WhereModifyFun<M, V> exists(GetterFun<M, V> ... cols) {
        this.whereFun.exists(cols);
        return this;
    }

    public WhereModifyFun<M, V> exists(boolean condition, GetterFun<M, V> ... cols) {
        this.whereFun.exists(condition, cols);
        return this;
    }

    @Override
    public Integer ex() {
        BaseBrief instance = BaseBriefImpl.getInstance((HeadCondition)this.conditions.peekFirst());
        MoreSQLInfo moreSqlInfo = (MoreSQLInfo)StatementParserAdepter.statementParse(this.conditions);
        List<SQLStatement> sqlStatements = moreSqlInfo.getSqlStatements();
        HashMap<String, List> sqlbatch = new HashMap<String, List>();
        for (SQLStatement sqlStatement : sqlStatements) {
            String sql2 = sqlStatement.getSql();
            List<Map<String, Object>> params2 = sqlStatement.getParams();
            LinkedList<Map<String, Object>> paramBatch = (LinkedList<Map<String, Object>>)sqlbatch.get(sql2);
            if (paramBatch == null) {
                paramBatch = new LinkedList<Map<String, Object>>();
                sqlbatch.put(sql2, paramBatch);
            }
            paramBatch.addAll(params2);
        }
        if (sqlbatch.size() == 0) {
            throw new UpdateFieldsException("Update fields must be specified.Even npdate Null must be at least one update field");
        }
        AtomicInteger count = new AtomicInteger();
        sqlbatch.forEach((sql, params) -> {
            Integer integer = instance.batchUpdate((String)sql, (List<Map<String, Object>>)params);
            count.addAndGet(integer);
        });
        return count.get();
    }

    @Override
    public SmartUpdateFun<M, GetterFun<M, Object>, V> addBatch() {
        this.conditions.add(new AddPatchMarkCondition());
        return new SmartUpdateFunImpl(this.modelClass, this.conditions, this.isUpdateNull);
    }
}

