/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.general.impl;

import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveFlag;
import com.javaoffers.brief.modelhelper.anno.derive.flag.DeriveInfo;
import com.javaoffers.brief.modelhelper.anno.derive.flag.IsDel;
import com.javaoffers.brief.modelhelper.anno.derive.flag.RowStatus;
import com.javaoffers.brief.modelhelper.anno.derive.flag.Version;
import com.javaoffers.brief.modelhelper.core.ConvertRegisterSelectorDelegate;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.exception.ParseParamException;
import com.javaoffers.brief.modelhelper.exception.PrimaryKeyNotFoundException;
import com.javaoffers.brief.modelhelper.exception.QueryDataException;
import com.javaoffers.brief.modelhelper.exception.UpdateFieldsException;
import com.javaoffers.brief.modelhelper.fun.GetterFun;
import com.javaoffers.brief.modelhelper.fun.crud.WhereFun;
import com.javaoffers.brief.modelhelper.fun.crud.WhereModifyFun;
import com.javaoffers.brief.modelhelper.fun.crud.WhereSelectFun;
import com.javaoffers.brief.modelhelper.fun.crud.delete.DeleteWhereFun;
import com.javaoffers.brief.modelhelper.fun.crud.impl.SelectFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.delete.DeleteFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.insert.InsertFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.insert.MoreInsertFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.impl.update.UpdateFunImpl;
import com.javaoffers.brief.modelhelper.fun.crud.insert.MoreInsertFun;
import com.javaoffers.brief.modelhelper.fun.crud.update.SmartUpdateFun;
import com.javaoffers.brief.modelhelper.fun.general.GeneralFun;
import com.javaoffers.brief.modelhelper.fun.general.impl.NativeFunImpl;
import com.javaoffers.brief.modelhelper.utils.Assert;
import com.javaoffers.brief.modelhelper.utils.ColNameAndColValueUtils;
import com.javaoffers.brief.modelhelper.utils.Lists;
import com.javaoffers.brief.modelhelper.utils.SQLType;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

public class GeneralFunImpl<T, C extends GetterFun<T, Object>, V>
implements GeneralFun<T, C, V> {
    static ConvertRegisterSelectorDelegate convert = ConvertRegisterSelectorDelegate.convert;
    private AtomicInteger ato = new AtomicInteger(0);
    private Class<T> mClass;
    private SelectFunImpl<T> selectFun;
    private InsertFunImpl<T> insertFun;
    private UpdateFunImpl<T, C, V> updateFun;
    private DeleteFunImpl<T> deleteFun;
    private NativeFunImpl nativeFun;
    private String tableName;
    private String primaryColNmae;
    private Field numOrStringField;
    private Field primaryField;
    private TableInfo tableInfo;

    public GeneralFunImpl(Class<T> mClass, SelectFunImpl<T> selectFun, InsertFunImpl<T> insertFun, UpdateFunImpl<T, C, V> updateFun, DeleteFunImpl<T> deleteFun, NativeFunImpl nativeFun) {
        Map primaryColNames;
        this.mClass = mClass;
        this.selectFun = selectFun;
        this.insertFun = insertFun;
        this.updateFun = updateFun;
        this.deleteFun = deleteFun;
        this.tableName = TableHelper.getTableName(mClass);
        this.tableInfo = TableHelper.getTableInfo(mClass);
        this.nativeFun = nativeFun;
        Collection fields = this.tableInfo.getFieldNameAndField().values();
        for (Field field : fields) {
            Class type = Utils.baseClassUpgrade(field.getType());
            if (!Number.class.isAssignableFrom(type) && !String.class.isAssignableFrom(type)) continue;
            this.numOrStringField = field;
            break;
        }
        if (MapUtils.isEmpty((Map)(primaryColNames = this.tableInfo.getPrimaryColNames()))) {
            return;
        }
        this.primaryColNmae = (String)primaryColNames.keySet().iterator().next();
        this.primaryField = (Field)((List)this.tableInfo.getColNameAndFieldOfModel().get(this.primaryColNmae)).get(0);
    }

    @Override
    public Id save(T model) {
        if (model == null) {
            return Id.EMPTY_ID;
        }
        Id ex = (Id)this.insertFun.colAll(model).ex();
        if (ex != null) {
            return ex;
        }
        return Id.EMPTY_ID;
    }

    @Override
    public void saveOrModify(T model) {
        if (model == null) {
            return;
        }
        ArrayList<T> models = new ArrayList<T>();
        models.add(model);
        this.saveOrModify((Collection<T>)models);
    }

    @Override
    public void saveOrReplace(T model) {
        if (model == null) {
            return;
        }
        this.saveOrReplace(Lists.newArrayList((Object[])new Object[]{model}));
    }

    @Override
    public List<Id> saveBatch(Collection<T> models) {
        if (CollectionUtils.isEmpty(models)) {
            return Collections.EMPTY_LIST;
        }
        List<Id> exs = this.insertFun.colAll(models).exs();
        if (exs != null) {
            return exs;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void saveOrModify(Collection<T> models) {
        if (CollectionUtils.isEmpty(models)) {
            return;
        }
        if (this.tableInfo.getDbType().isSupportDuplicateModify()) {
            MoreInsertFun<T, GetterFun<T, Object>, Object> moreInserFun = this.insertFun.colAll(models);
            ((MoreInsertFunImpl)moreInserFun).dupUpdate().exs();
        } else {
            List<T> updateList = this.saveWithFails(models);
            this.modifyBatchById(updateList);
        }
    }

    @Override
    public void saveOrReplace(Collection<T> models) {
        List<T> updateList = this.saveWithFails(models);
        this.replaceBatchById(updateList);
    }

    @Override
    public int remove(T model) {
        if (model == null) {
            return 0;
        }
        DeleteWhereFun<T, GetterFun<T, Object>, Object> where = this.deleteFun.where();
        AtomicBoolean status = this.parseWhere(model, where);
        if (status.get()) {
            return (Integer)where.ex();
        }
        return 0;
    }

    @Override
    public int removeById(Serializable id) {
        return this.removeByIds(id);
    }

    @Override
    public int removeByIds(Serializable ... ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        Set idSet = Arrays.stream(ids).collect(Collectors.toSet());
        return this.removeByIds((Collection)idSet);
    }

    @Override
    public int logicRemove(T model) {
        if (model == null) {
            return 0;
        }
        T newModel = this.getLogicRemoveModel();
        WhereModifyFun where = this.updateFun.npdateNull().colAll(newModel).where();
        if (this.parseWhere(model, where).get()) {
            return (Integer)where.ex();
        }
        return 0;
    }

    @Override
    public int logicRemoveById(Serializable id) {
        HashSet<Serializable> ids = new HashSet<Serializable>();
        ids.add(id);
        return this.logicRemoveByIds((Collection)ids);
    }

    @Override
    public int logicRemoveByIds(Serializable ... ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return 0;
        }
        Set idsSet = Arrays.stream(ids).filter(Objects::nonNull).collect(Collectors.toSet());
        return this.logicRemoveByIds(idsSet);
    }

    @Override
    public <ID extends Serializable> int logicRemoveByIds(Collection<ID> ids) {
        this.assertPrimary();
        if (CollectionUtils.isEmpty(ids)) {
            return 0;
        }
        T logicRemoveModel = this.getLogicRemoveModel();
        WhereModifyFun where = this.updateFun.npdateNull().colAll(logicRemoveModel).where();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String newColNameTag = this.getNewColNameTag();
        param.putIfAbsent(newColNameTag, ids);
        where.condSQL(this.tableName + "." + this.primaryColNmae + " in (#{" + newColNameTag + "})", param);
        return (Integer)where.ex();
    }

    @Override
    public int removeByIds(Collection ids) {
        this.assertPrimary();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return 0;
        }
        DeleteWhereFun<T, GetterFun<T, Object>, Object> where = this.deleteFun.where();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String newColNameTag = this.getNewColNameTag();
        param.putIfAbsent(newColNameTag, ids);
        where.condSQL(this.primaryColNmae + " in ( #{" + newColNameTag + "} ) ", param);
        return (Integer)where.ex();
    }

    @Override
    public int modifyById(T model) {
        if (model != null) {
            return this.modifyBatchById(Lists.newArrayList((Object[])new Object[]{model}));
        }
        return 0;
    }

    @Override
    public int replaceById(T model) {
        if (model == null) {
            return 0;
        }
        return this.renovateBatchById(Lists.newArrayList((Object[])new Object[]{model}), true);
    }

    @Override
    public int modifyBatchById(Collection<T> models) {
        return this.renovateBatchById(models, false);
    }

    @Override
    public int replaceBatchById(Collection<T> models) {
        return this.renovateBatchById(models, true);
    }

    @Override
    public int vsModifyById(T model) {
        if (model == null) {
            return 0;
        }
        return this.renovateByIdWithVersion(Lists.newArrayList((Object[])new Object[]{model}), false);
    }

    @Override
    public int vsReplaceById(T model) {
        if (model == null) {
            return 0;
        }
        return this.renovateByIdWithVersion(Lists.newArrayList((Object[])new Object[]{model}), true);
    }

    @Override
    public int vsModifyByIds(Collection<T> models) {
        if (CollectionUtils.isEmpty(models)) {
            return 0;
        }
        return this.renovateByIdWithVersion(models, false);
    }

    @Override
    public int vsReplaceByIds(Collection<T> models) {
        if (CollectionUtils.isEmpty(models)) {
            return 0;
        }
        return this.renovateByIdWithVersion(models, true);
    }

    @Override
    public List<T> query(T model) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Pair<Boolean, WhereSelectFun<T, Object>> whereInfo = this.parseQueryWhere(model);
        if (!((Boolean)whereInfo.getLeft()).booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        WhereSelectFun where = (WhereSelectFun)whereInfo.getRight();
        return where.exs();
    }

    @Override
    public T queryOne(T model) {
        List<T> list = this.query(model);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public T queryOnlyOne(T model) {
        List<T> list = this.query(model);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        if (list.size() != 1) {
            throw new QueryDataException("There are multiple query data");
        }
        return list.get(0);
    }

    @Override
    public List<T> query(T model, int pageNum, int pageSize) {
        if (model == null) {
            return Collections.EMPTY_LIST;
        }
        Pair<Boolean, WhereSelectFun<T, Object>> whereInfo = this.parseQueryWhere(model);
        if (!((Boolean)whereInfo.getLeft()).booleanValue()) {
            return Collections.EMPTY_LIST;
        }
        WhereSelectFun where = (WhereSelectFun)whereInfo.getRight();
        where.limitPage(pageNum, pageSize);
        return where.exs();
    }

    @Override
    public List<T> query(int pageNum, int pageSize) {
        List exs;
        if (pageNum <= 0) {
            pageNum = 1;
        }
        if (pageSize <= 0) {
            pageSize = 10;
        }
        if ((exs = ((WhereSelectFun)this.selectFun.colAll().where().limitPage(pageNum, pageSize)).exs()) == null) {
            exs = Collections.EMPTY_LIST;
        }
        return exs;
    }

    @Override
    public T queryById(Serializable id) {
        if (id == null) {
            return null;
        }
        List<T> ts = this.queryByIds(id);
        if (ts == null || ts.size() == 0) {
            return null;
        }
        return ts.get(0);
    }

    @Override
    public List<T> queryByIds(Serializable ... ids) {
        if (ids == null || ids.length == 0) {
            return Collections.EMPTY_LIST;
        }
        Set idSet = Arrays.stream(ids).collect(Collectors.toSet());
        return this.queryByIds(idSet);
    }

    @Override
    public List<T> queryByIds(Collection ids) {
        this.assertPrimary();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return Collections.EMPTY_LIST;
        }
        WhereSelectFun<T, Object> where = this.selectFun.colAll().where();
        HashMap<String, Object> param = new HashMap<String, Object>();
        String newColNameTag = this.getNewColNameTag();
        param.put(newColNameTag, ids);
        where.condSQL(this.primaryColNmae + " in ( #{" + newColNameTag + "} ) ", param);
        List exs = where.exs();
        if (exs != null && exs.size() > 0) {
            return exs;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<T> queryByIds(List ids) {
        return this.queryByIds((Collection)ids);
    }

    @Override
    public List<T> queryByIds(Set ids) {
        return this.queryByIds((Collection)ids);
    }

    @Override
    public List<T> queryByParam(Map<String, Object> param) {
        if (MapUtils.isEmpty(param)) {
            return Collections.EMPTY_LIST;
        }
        return this.queryByParam(param, -1, -1, false);
    }

    @Override
    public List<T> queryByParam(Map<String, Object> param, int pageNum, int pageSize) {
        return this.queryByParam(param, pageNum, pageSize, true);
    }

    @Override
    public Number count() {
        Object ex = this.selectFun.col("count(1) as " + this.numOrStringField.getName()).where().ex();
        return this.getNumber(this.numOrStringField, ex);
    }

    @Override
    public Number count(C c) {
        Assert.isTrue((c != null ? 1 : 0) != 0, (String)" count is null .");
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(c);
        Object ex = this.selectFun.col("count(" + (String)colNameAndAliasName.getLeft() + ") as " + this.numOrStringField.getName()).where().ex();
        return this.getNumber(this.numOrStringField, ex);
    }

    @Override
    public Number countDistinct(C c) {
        Assert.isTrue((c != null ? 1 : 0) != 0, (String)" count is null .");
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(c);
        Object ex = this.selectFun.col("count(Distinct(" + (String)colNameAndAliasName.getLeft() + ")) as " + this.numOrStringField.getName()).where().ex();
        return this.getNumber(this.numOrStringField, ex);
    }

    @Override
    public Number count(T model) {
        WhereSelectFun<T, Object> where = this.selectFun.col("count(1) as " + this.numOrStringField.getName()).where();
        if (this.parseWhere(model, where).get()) {
            Object ex = where.ex();
            return this.getNumber(this.numOrStringField, ex);
        }
        return 0L;
    }

    @Override
    public Number count(C c, T model) {
        Assert.isTrue((c != null ? 1 : 0) != 0, (String)" count is null .");
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(c);
        WhereSelectFun<T, Object> where = this.selectFun.col("count(" + (String)colNameAndAliasName.getLeft() + ") as " + this.numOrStringField.getName()).where();
        if (this.parseWhere(model, where).get()) {
            Object ex = where.ex();
            return this.getNumber(this.numOrStringField, ex);
        }
        return 0L;
    }

    @Override
    public Number countDistinct(C c, T model) {
        Assert.isTrue((c != null ? 1 : 0) != 0, (String)" count is null .");
        Pair colNameAndAliasName = TableHelper.getColNameAndAliasName(c);
        WhereSelectFun<T, Object> where = this.selectFun.col("count(Distinct(" + (String)colNameAndAliasName.getLeft() + ")) as " + this.numOrStringField.getName()).where();
        if (this.parseWhere(model, where).get()) {
            Object ex = where.ex();
            return this.getNumber(this.numOrStringField, ex);
        }
        return 0L;
    }

    @Override
    public String ddlSQL(String sql) {
        return this.nativeFun.setSqlText(sql, SQLType.DDL).ex();
    }

    @Override
    public String ddlSQL(String sql, Map<String, Object> param) {
        return this.nativeFun.setSqlText(sql, SQLType.DDL).setParamMap(param).ex();
    }

    private Pair<Boolean, WhereSelectFun<T, Object>> parseQueryWhere(T model) {
        WhereSelectFun<T, Object> where = this.selectFun.colAll().where();
        AtomicBoolean isExecute = this.parseWhere(model, where);
        return Pair.of((Object)isExecute.get(), where);
    }

    private List<T> queryByParam(Map<String, Object> param, int pageNum, int pageSize, boolean isPage) {
        if (param != null && param.size() > 0) {
            WhereSelectFun<T, Object> where = this.selectFun.colAll().where();
            AtomicBoolean status = new AtomicBoolean(false);
            param.forEach((colName, value) -> {
                HashMap<String, Object> param_ = new HashMap<String, Object>();
                String newColNameTag = this.getNewColNameTag();
                param_.put(newColNameTag, value);
                where.condSQL(colName + " in ( #{" + newColNameTag + "} ) ", param_);
                status.set(true);
            });
            if (status.get()) {
                List exs;
                if (isPage) {
                    where.limitPage(pageNum, pageSize);
                }
                if ((exs = where.exs()) != null) {
                    return exs;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    private String getNewColNameTag() {
        return this.ato.getAndIncrement() + "_G_";
    }

    private TableInfo getTableInfo(Class modelClass) {
        TableInfo tableInfo = TableHelper.getTableInfo((Class)modelClass);
        Assert.isTrue((tableInfo != null ? 1 : 0) != 0, (String)"The table information corresponding to this class cannot be queried");
        return tableInfo;
    }

    private AtomicBoolean parseWhere(T model, WhereFun where) {
        AtomicBoolean status = new AtomicBoolean(false);
        Map colNameAndColValue = ColNameAndColValueUtils.parseColNameAndColValue(model, this.mClass);
        if (MapUtils.isNotEmpty((Map)colNameAndColValue)) {
            status.set(true);
            colNameAndColValue.forEach((colName, colValue) -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                String newColNameTag = this.getNewColNameTag();
                param.putIfAbsent(newColNameTag, colValue);
                where.condSQL(colName + " in ( #{" + newColNameTag + "} ) ", param);
            });
        }
        return status;
    }

    private void parseWhereById(WhereModifyFun<T, V> where, AtomicBoolean status, T model) {
        Map coNameAndColValue = ColNameAndColValueUtils.parseUniqueCoNameAndUniqueColValue(model, this.mClass);
        if (MapUtils.isNotEmpty((Map)coNameAndColValue)) {
            status.set(true);
            coNameAndColValue.forEach((uniqueColName, uniqueColValue) -> {
                HashMap<String, Object> param = new HashMap<String, Object>();
                String newColNameTag = this.getNewColNameTag();
                param.put(newColNameTag, uniqueColValue);
                where.condSQL(uniqueColName + " in ( #{" + newColNameTag + "} ) ", param);
            });
        }
    }

    private long getNumber(Field field, T ex) {
        if (ex == null) {
            return 0L;
        }
        Object o = null;
        try {
            o = field.get(ex);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    private int renovateBatchById(Collection<T> models, boolean updateNull) {
        if (models == null || models.size() == 0) {
            return 0;
        }
        models = models.stream().filter(Objects::nonNull).collect(Collectors.toList());
        WhereModifyFun where = null;
        AtomicBoolean status = new AtomicBoolean(false);
        SmartUpdateFun<T, C, V> npdateNull = updateNull ? this.updateFun.updateNull() : this.updateFun.npdateNull();
        int i = 0;
        for (Object model : models) {
            if (i == 0) {
                where = npdateNull.colAll(model).where();
            } else {
                where.addBatch().colAll(model).where();
                this.ato = new AtomicInteger(0);
            }
            ++i;
            AtomicBoolean status_ = new AtomicBoolean(false);
            this.parseWhereById(where, status_, model);
            if (!status_.get()) {
                where.condSQL(" 1 = 2 ");
                continue;
            }
            status.set(true);
        }
        if (status.get()) {
            return (Integer)where.ex();
        }
        return 0;
    }

    private int renovateByIdWithVersion(Collection<T> models, boolean updateNull) {
        if (models == null || models.size() == 0) {
            return 0;
        }
        DeriveInfo deriveColName = this.tableInfo.getDeriveColName(DeriveFlag.VERSION);
        if (deriveColName == null) {
            throw new ParseParamException(this.mClass.getName() + " no version field or col name");
        }
        Field versionField = deriveColName.getField();
        String versionColName = deriveColName.getColName();
        int modifyCount = 0;
        for (T model : models) {
            if (model == null) continue;
            SmartUpdateFun<T, C, V> npdateNull = updateNull ? this.updateFun.updateNull() : this.updateFun.npdateNull();
            boolean versionIsNull = false;
            Version version = null;
            try {
                version = (Version)versionField.get(model);
                if (version == null) {
                    version = new Version(0L);
                    versionField.set(model, version);
                    versionIsNull = true;
                }
            }
            catch (Exception e) {
                throw new ParseParamException("Parsing the version information failure");
            }
            WhereModifyFun where = npdateNull.colAll(model).where();
            AtomicBoolean status_ = new AtomicBoolean(false);
            this.parseWhereById(where, status_, model);
            if (!status_.get()) continue;
            if (versionIsNull) {
                where.condSQL(this.tableName + "." + versionColName + " is null");
            } else {
                where.condSQL(this.tableName + "." + versionColName + " in (" + version.get() + ")");
            }
            version.incrementAndGet();
            int i1 = (Integer)where.ex();
            if (i1 == 0) {
                version.decrementAndGet();
                continue;
            }
            modifyCount += i1;
        }
        return modifyCount;
    }

    private T getLogicRemoveModel() {
        try {
            T newModel = this.mClass.newInstance();
            TableInfo tableInfo = TableHelper.getTableInfo(this.mClass);
            DeriveInfo deriveColName = tableInfo.getDeriveColName(DeriveFlag.IS_DEL);
            Field logicRemoveField = null;
            Assert.isTrue((deriveColName != null && (logicRemoveField = deriveColName.getField()) != null ? 1 : 0) != 0, (String)"no  logic del col, please use IsDel to declaration");
            if (deriveColName.isDelField()) {
                logicRemoveField.set(newModel, IsDel.YES);
            } else {
                logicRemoveField.set(newModel, RowStatus.ABSENT);
            }
            return newModel;
        }
        catch (Exception e) {
            throw new UpdateFieldsException(e.getMessage());
        }
    }

    private void assertPrimary() {
        if (this.primaryColNmae == null || this.primaryField == null) {
            throw new PrimaryKeyNotFoundException(this.tableName + " not primary key ");
        }
    }

    private List<T> saveWithFails(Collection<T> models) {
        ArrayList updateList = Lists.newArrayList();
        for (T model : models) {
            try {
                this.save(model);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().toLowerCase().contains("duplicate")) {
                    updateList.add(model);
                    continue;
                }
                throw e;
            }
        }
        return updateList;
    }
}

