/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.fun.general.impl;

import com.javaoffers.brief.modelhelper.core.BaseBrief;
import com.javaoffers.brief.modelhelper.core.BaseBriefImpl;
import com.javaoffers.brief.modelhelper.core.CrudMapperMethodThreadLocal;
import com.javaoffers.brief.modelhelper.fun.ExecutFun;
import com.javaoffers.brief.modelhelper.fun.HeadCondition;
import com.javaoffers.brief.modelhelper.utils.GsonUtils;
import com.javaoffers.brief.modelhelper.utils.Lists;
import com.javaoffers.brief.modelhelper.utils.SQLType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public class NativeFunImpl
implements ExecutFun<String> {
    private String sqlText;
    private SQLType sqlType;
    private Map<String, Object> paramMap = Collections.emptyMap();
    private DataSource dataSource;
    private Class modelClass = CrudMapperMethodThreadLocal.getExcutorModel();

    public NativeFunImpl() {
        this.dataSource = CrudMapperMethodThreadLocal.getExcutorDataSource();
    }

    public NativeFunImpl setSqlText(String sqlText, SQLType sqlType) {
        this.sqlText = sqlText;
        this.sqlType = sqlType;
        return this;
    }

    public NativeFunImpl setParamMap(Map<String, Object> paramMap) {
        this.paramMap = paramMap;
        return this;
    }

    @Override
    public String ex() {
        List<String> exs = this.exs();
        if (exs.size() > 0) {
            return exs.stream().collect(Collectors.joining("\t\n"));
        }
        return "OK";
    }

    @Override
    public List<String> exs() {
        if (StringUtils.isBlank((CharSequence)this.sqlText)) {
            return Lists.newArrayList();
        }
        HeadCondition headCondition = new HeadCondition(this.dataSource, this.modelClass);
        BaseBrief instance = BaseBriefImpl.getInstance(headCondition);
        List<String> list = instance.nativeData(this.sqlText, this.paramMap, this.sqlType);
        return list.stream().map(el -> {
            if (el instanceof List) {
                List ls = (List)el;
                return ls.stream().map(Object::toString).collect(Collectors.joining("\t"));
            }
            return GsonUtils.gson.toJson(el);
        }).collect(Collectors.toList());
    }
}

