/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.jdbc;

import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.jdbc.BriefModifyExecutor;
import com.javaoffers.brief.modelhelper.jdbc.BriefQueryExecutor;
import com.javaoffers.brief.modelhelper.jdbc.BriefSaveExecutor;
import com.javaoffers.brief.modelhelper.jdbc.JdbcExecutor;
import java.util.List;
import javax.sql.DataSource;

public class BriefJdbcExecutor<T>
implements JdbcExecutor<T> {
    DataSource dataSource;
    Class<T> modelClass;

    public BriefJdbcExecutor(DataSource dataSource, Class<T> modelClass) {
        this.dataSource = dataSource;
        this.modelClass = modelClass;
    }

    public Id save(BaseSQLInfo sql) {
        return new BriefSaveExecutor(this.dataSource).save(sql);
    }

    public List<Id> batchSave(BaseSQLInfo sql) {
        return new BriefSaveExecutor(this.dataSource).batchSave(sql);
    }

    public int modify(BaseSQLInfo sql) {
        return new BriefModifyExecutor(this.dataSource).modify(sql);
    }

    public int batchModify(BaseSQLInfo sql) {
        return new BriefModifyExecutor(this.dataSource).batchModify(sql);
    }

    public T query(BaseSQLInfo sql) {
        return new BriefQueryExecutor(this.dataSource, this.modelClass).query(sql);
    }

    public List<T> queryList(BaseSQLInfo sql) {
        return new BriefQueryExecutor(this.dataSource, this.modelClass).queryList(sql);
    }

    public void queryStream(BaseSQLInfo sql) {
        new BriefQueryExecutor(this.dataSource, this.modelClass).queryStream(sql);
    }
}

