/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.jdbc;

import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.exception.SqlParseException;
import com.javaoffers.brief.modelhelper.jdbc.ModifyExecutor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import javax.sql.DataSource;

public class BriefModifyExecutor
implements ModifyExecutor {
    DataSource dataSource;

    public BriefModifyExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int modify(BaseSQLInfo sql) {
        return this.batchModify(sql);
    }

    public int batchModify(BaseSQLInfo sql) {
        Connection connection = null;
        Boolean oldAutoCommit = null;
        try {
            Object ov;
            int pi;
            connection = this.getConnection();
            String nativeSql = sql.getSql();
            List argsParam = sql.getArgsParam();
            oldAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(nativeSql);
            int size = argsParam.size();
            int y = size % 2;
            if (size > 1) {
                if (y == 1) {
                    Object[] p = (Object[])argsParam.remove(0);
                    pi = 0;
                    while (pi < p.length) {
                        ov = p[pi];
                        ps.setObject(++pi, ov);
                    }
                    ps.addBatch();
                }
                size = argsParam.size();
                int i = 0;
                for (int j = 1; i < size && j < size; i += 2, j += 2) {
                    Object ov2;
                    Object[] p = (Object[])argsParam.get(i);
                    Object[] p2 = (Object[])argsParam.get(j);
                    int pi2 = 0;
                    while (pi2 < p.length) {
                        ov2 = p[pi2];
                        ps.setObject(++pi2, ov2);
                    }
                    ps.addBatch();
                    pi2 = 0;
                    while (pi2 < p2.length) {
                        ov2 = p2[pi2];
                        ps.setObject(++pi2, ov2);
                    }
                    ps.addBatch();
                }
            } else if (size == 1) {
                Object[] p = (Object[])argsParam.get(0);
                pi = 0;
                while (pi < p.length) {
                    ov = p[pi];
                    ps.setObject(++pi, ov);
                }
                ps.addBatch();
            } else {
                int p = 0;
                return p;
            }
            int[] ints = ps.executeBatch();
            ps.clearBatch();
            if (oldAutoCommit.booleanValue()) {
                connection.commit();
                connection.setAutoCommit(oldAutoCommit);
            }
            int count = 0;
            for (int i : ints) {
                count += i;
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlParseException(e.getMessage());
        }
        finally {
            if (connection == null && oldAutoCommit != null) {
                try {
                    connection.setAutoCommit(oldAutoCommit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SqlParseException(e.getMessage());
                }
            }
            this.closeConnection(connection, oldAutoCommit);
        }
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlParseException(e.getMessage());
        }
    }
}

