/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.jdbc;

import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.exception.ParseResultSetException;
import com.javaoffers.brief.modelhelper.exception.SqlParseException;
import com.javaoffers.brief.modelhelper.jdbc.BriefResultSetExecutor;
import com.javaoffers.brief.modelhelper.jdbc.QueryExecutor;
import com.javaoffers.brief.modelhelper.jdbc.ResultSetExecutor;
import com.javaoffers.brief.modelhelper.parse.ModelParseUtils;
import com.javaoffers.brief.modelhelper.utils.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;

public class BriefQueryExecutor<T>
implements QueryExecutor<T> {
    DataSource dataSource;
    Class<T> modelClass;

    public BriefQueryExecutor(DataSource dataSource, Class modelClass) {
        this.dataSource = dataSource;
        this.modelClass = modelClass;
    }

    public T query(BaseSQLInfo sql) {
        List<T> ts = this.queryList(sql);
        if (CollectionUtils.isEmpty(ts)) {
            return null;
        }
        return ts.get(0);
    }

    public List<T> queryList(BaseSQLInfo sql) {
        boolean oldAutoCommitStatus = false;
        Connection connection = null;
        try {
            Object ov;
            connection = this.getConnection();
            oldAutoCommitStatus = connection.getAutoCommit();
            PreparedStatement ps = connection.prepareStatement(sql.getSql());
            List argsParam = sql.getArgsParam();
            if (argsParam != null && argsParam.size() == 1) {
                ov = (Object[])argsParam.get(0);
                int i = 0;
                while (i < ((Object[])ov).length) {
                    Object o = ov[i];
                    ps.setObject(++i, o);
                }
            }
            switch (sql.getSqlType()) {
                case JOIN_SELECT: {
                    ov = ModelParseUtils.converterResultSet2ModelForJoinSelect(this.modelClass, (ResultSetExecutor)new BriefResultSetExecutor(ps.executeQuery()));
                    return ov;
                }
                case NORMAL_SELECT: {
                    ov = ModelParseUtils.converterResultSet2ModelForNormalSelect(this.modelClass, (ResultSetExecutor)new BriefResultSetExecutor(ps.executeQuery()));
                    return ov;
                }
                case DML: 
                case DDL: {
                    boolean execute = ps.execute();
                    ArrayList dmlResult = Lists.newArrayList();
                    if (execute) {
                        ResultSet rs = ps.getResultSet();
                        while (rs.next()) {
                            ArrayList dmlCol = Lists.newArrayList();
                            int columnCount = rs.getMetaData().getColumnCount();
                            for (int i = 1; i <= columnCount; ++i) {
                                dmlCol.add(rs.getString(i));
                            }
                            if (dmlCol.size() <= 0) continue;
                            dmlResult.add(dmlCol);
                        }
                    } else {
                        dmlResult.add(true);
                    }
                    ArrayList arrayList = dmlResult;
                    return arrayList;
                }
            }
            try {
                throw new ParseResultSetException("sql type does not exist");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SqlParseException(e.getMessage());
            }
        }
        finally {
            this.closeConnection(connection, oldAutoCommitStatus);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void queryStream(BaseSQLInfo sql) {
        boolean oldAutoCommitStatus = false;
        Connection connection = null;
        try {
            connection = this.getConnection();
            oldAutoCommitStatus = connection.getAutoCommit();
            PreparedStatement ps = connection.prepareStatement(sql.getSql());
            List argsParam = sql.getArgsParam();
            if (argsParam != null && argsParam.size() == 1) {
                Object[] ov = (Object[])argsParam.get(0);
                int i = 0;
                while (i < ov.length) {
                    Object o = ov[i];
                    ps.setObject(++i, o);
                }
            }
            switch (sql.getSqlType()) {
                case JOIN_SELECT: {
                    ModelParseUtils.converterResultSet2ModelForJoinSelectStream(this.modelClass, (ResultSetExecutor)new BriefResultSetExecutor(ps.executeQuery()), (Consumer)sql.getStreaming());
                    return;
                }
                case NORMAL_SELECT: {
                    ModelParseUtils.converterResultSet2ModelForNormalSelectStream(this.modelClass, (ResultSetExecutor)new BriefResultSetExecutor(ps.executeQuery()), (Consumer)sql.getStreaming());
                    return;
                }
                default: {
                    throw new ParseResultSetException("sql type does not exist for streaming process");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlParseException(e.getMessage());
        }
        finally {
            this.closeConnection(connection, oldAutoCommitStatus);
        }
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlParseException(e.getMessage());
        }
    }
}

