/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.jdbc;

import com.javaoffers.brief.modelhelper.exception.ParseResultSetException;
import com.javaoffers.brief.modelhelper.jdbc.ResultSetExecutor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BriefResultSetExecutor
implements ResultSetExecutor {
    static Logger logger = LoggerFactory.getLogger(BriefResultSetExecutor.class);
    private List<String> colNames = new ArrayList<String>();
    private Map<String, Boolean> colNameBool = new HashMap<String, Boolean>();
    private ResultSet resultSet;

    public BriefResultSetExecutor(ResultSet resultSet) {
        this.resultSet = resultSet;
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                String columnLabel = metaData.getColumnLabel(++i);
                this.colNames.add(columnLabel);
                this.colNameBool.put(columnLabel, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseResultSetException(e.getMessage());
        }
    }

    public List<String> getColNames() {
        return this.colNames;
    }

    public Object getColValueByColName(String colName) {
        try {
            if (this.colNameBool.containsKey(colName)) {
                return this.resultSet.getObject(colName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("colName:{} result is null", (Object)colName);
        }
        return null;
    }

    public Object getColValueByColPosition(int position) {
        try {
            return this.resultSet.getObject(position);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("colName:{} result is null", (Object)position);
            return null;
        }
    }

    public boolean nextRow() {
        try {
            return this.resultSet.next();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseResultSetException(e.getMessage());
        }
    }
}

