/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.jdbc;

import com.javaoffers.brief.modelhelper.convert.Serializable2IdConvert;
import com.javaoffers.brief.modelhelper.core.BaseSQLInfo;
import com.javaoffers.brief.modelhelper.core.Id;
import com.javaoffers.brief.modelhelper.exception.SqlParseException;
import com.javaoffers.brief.modelhelper.jdbc.SaveExecutor;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class BriefSaveExecutor
implements SaveExecutor {
    DataSource dataSource;

    public BriefSaveExecutor(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Id save(BaseSQLInfo sql) {
        List<Id> ids = this.batchSave(sql);
        if (ids != null && ids.size() > 0) {
            return ids.get(0);
        }
        return Id.EMPTY_ID;
    }

    public List<Id> batchSave(BaseSQLInfo sql) {
        Connection connection = null;
        Boolean oldAutoCommit = null;
        int batchSize = sql.getBatchSize();
        ArrayList<Id> ids = new ArrayList<Id>();
        try {
            Object ov;
            int pi;
            connection = this.getConnection();
            String nativeSql = sql.getSql();
            List argsParam = sql.getArgsParam();
            oldAutoCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            int autoGeneratedKeys = sql.getDbType().getAutoGeneratedKeys();
            PreparedStatement ps = connection.prepareStatement(nativeSql, autoGeneratedKeys);
            int size = argsParam.size();
            int y = size % 2;
            if (size > 1) {
                if (y == 1) {
                    Object[] p = (Object[])argsParam.remove(0);
                    pi = 0;
                    while (pi < p.length) {
                        ov = p[pi];
                        ps.setObject(++pi, ov);
                    }
                    ps.addBatch();
                }
                size = argsParam.size();
                int i = 0;
                for (int j = 1; i < size && j < size; i += 2, j += 2) {
                    Object ov2;
                    Object[] p = (Object[])argsParam.get(i);
                    Object[] p2 = (Object[])argsParam.get(j);
                    int pi2 = 0;
                    while (pi2 < p.length) {
                        ov2 = p[pi2];
                        ps.setObject(++pi2, ov2);
                    }
                    ps.addBatch();
                    pi2 = 0;
                    while (pi2 < p2.length) {
                        ov2 = p2[pi2];
                        ps.setObject(++pi2, ov2);
                    }
                    ps.addBatch();
                }
            } else if (size == 1) {
                Object[] p = (Object[])argsParam.get(0);
                pi = 0;
                while (pi < p.length) {
                    ov = p[pi];
                    ps.setObject(++pi, ov);
                }
                ps.addBatch();
            } else {
                ArrayList<Id> p = ids;
                return p;
            }
            ps.executeBatch();
            ps.clearBatch();
            if (oldAutoCommit.booleanValue()) {
                connection.commit();
            }
            ResultSet rs = ps.getGeneratedKeys();
            for (int i = 0; rs.next() && i < batchSize; ++i) {
                Object object = rs.getObject(1);
                ids.add(Serializable2IdConvert.newId((Serializable)((Serializable)object)));
            }
        }
        catch (Exception e) {
            throw new SqlParseException(e.toString(), (Throwable)e);
        }
        finally {
            if (connection == null && oldAutoCommit != null) {
                try {
                    connection.setAutoCommit(oldAutoCommit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new SqlParseException(e.getMessage());
                }
            }
            this.closeConnection(connection, oldAutoCommit);
        }
        return ids;
    }

    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SqlParseException(e.getMessage());
        }
    }
}

