/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.mapper;

import com.javaoffers.brief.modelhelper.core.CrudMapperConstant;
import com.javaoffers.brief.modelhelper.core.CrudMapperMethodThreadLocal;
import com.javaoffers.brief.modelhelper.exception.ParseTableException;
import com.javaoffers.brief.modelhelper.mapper.BriefMapper;
import com.javaoffers.brief.modelhelper.util.HelperUtils;
import com.javaoffers.brief.modelhelper.utils.BriefUtils;
import com.javaoffers.brief.modelhelper.utils.FutureLock;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SmartMapperProxy
implements InvocationHandler,
Serializable {
    private static final Map<Method, String> mapperMethod = BriefUtils.getMapperMethod();
    private static final Map<Method, String> objectMethod = BriefUtils.getObjectMethod();
    private BriefMapper briefMapperJql;
    private volatile Class modelClass;
    private volatile DataSource dataSource;
    private FutureLock<Pair<Boolean, Exception>> status = new FutureLock();
    private volatile boolean isReady = false;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object connection;
            if (!this.isReady()) {
                if (this.status.tryLock()) {
                    connection = this.dataSource.getConnection();
                    try {
                        List modelClass = HelperUtils.parseAllModelClass((Class)this.modelClass);
                        for (Class mc : modelClass) {
                            TableHelper.parseTableInfo((Class)mc, (Connection)connection);
                        }
                        this.status.unlock((Object)Pair.of((Object)true, null));
                        this.setReadyOk();
                    }
                    catch (Exception e) {
                        this.status.unlock((Object)Pair.of((Object)false, (Object)e));
                        e.printStackTrace();
                        this.status.reset();
                        throw new ParseTableException("parse table info exception", (Throwable)e);
                    }
                    finally {
                        if (!connection.isClosed()) {
                            connection.close();
                        }
                    }
                } else if (!((Boolean)((Pair)this.status.getOrOld()).getLeft()).booleanValue()) {
                    throw new ParseTableException("parse table info exception", (Throwable)((Pair)this.status.get()).getRight());
                }
            }
            CrudMapperMethodThreadLocal.addExcutorModel(this.modelClass);
            CrudMapperMethodThreadLocal.addExcutorDataSource(this.dataSource);
            if (method.getModifiers() == 1) {
                connection = method.invoke((Object)this.briefMapperJql, args);
                return connection;
            }
            if (StringUtils.isNotBlank((CharSequence)mapperMethod.get(method)) && args == null) {
                if (method.getName().equals(CrudMapperConstant.SELECT.getMethodName())) {
                    connection = this.briefMapperJql.select();
                    return connection;
                }
                if (method.getName().equals(CrudMapperConstant.INSERT.getMethodName())) {
                    connection = this.briefMapperJql.insert();
                    return connection;
                }
                if (method.getName().equals(CrudMapperConstant.UPDATE.getMethodName())) {
                    connection = this.briefMapperJql.update();
                    return connection;
                }
                if (method.getName().equals(CrudMapperConstant.DELETE.getMethodName())) {
                    connection = this.briefMapperJql.delete();
                    return connection;
                }
                if (method.getName().equals(CrudMapperConstant.GENERAL.getMethodName())) {
                    connection = this.briefMapperJql.general();
                    return connection;
                }
                throw new IllegalAccessException("method not found ");
            }
            if (StringUtils.isNotBlank((CharSequence)objectMethod.get(method))) {
                connection = method.invoke((Object)this.briefMapperJql, args);
                return connection;
            }
            try {
                throw new IllegalAccessException("method not support ");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            CrudMapperMethodThreadLocal.delExcutorModel();
            CrudMapperMethodThreadLocal.delExcutorDataSource();
        }
    }

    public SmartMapperProxy(BriefMapper briefMapperJql, DataSource dataSource, Class modelClass) {
        this.briefMapperJql = briefMapperJql;
        this.dataSource = dataSource;
        this.modelClass = modelClass;
    }

    private boolean isReady() {
        return this.isReady;
    }

    private void setReadyOk() {
        this.isReady = true;
    }
}

