/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.convert;

import com.javaoffers.brief.modelhelper.consistant.ModelConsistants;
import com.javaoffers.brief.modelhelper.convert.AbstractConver;
import com.javaoffers.brief.modelhelper.core.ConverDescriptor;
import com.javaoffers.brief.modelhelper.core.ConvertRegisterSelectorDelegate;
import com.javaoffers.brief.modelhelper.core.Register;
import com.javaoffers.brief.modelhelper.utils.EnumValueUtils;
import java.lang.reflect.Field;

public class Number2EnumConvert
extends AbstractConver<Number, Enum> {
    @Override
    public Enum convert(Number number) {
        Class desClass = ConvertRegisterSelectorDelegate.processingConvertClass.get();
        T[] enumConstants = desClass.getEnumConstants();
        if (number != null && enumConstants != null) {
            Field enumValueField = EnumValueUtils.getEnumValueFields((Class)desClass);
            if (enumValueField == null) {
                if (enumConstants.length > number.intValue()) {
                    return (Enum)enumConstants[number.intValue()];
                }
            } else {
                for (Object o : enumConstants) {
                    try {
                        Object enumValue = enumValueField.get(o);
                        if (number.equals(enumValue)) {
                            return (Enum)o;
                        }
                        if (enumValue == null || !String.valueOf(enumValue).equals(number.toString())) continue;
                        return (Enum)o;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void register(Register register) {
        Class[] baseNumberClass;
        super.register(register);
        for (Class numClazz : baseNumberClass = ModelConsistants.baseNumberClass) {
            ConverDescriptor converDescriptor = new ConverDescriptor(numClazz, Enum.class);
            register.registerConvert(converDescriptor, this);
        }
    }
}

