/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.convert;

import com.javaoffers.brief.modelhelper.consistant.ModelConsistants;
import com.javaoffers.brief.modelhelper.convert.AbstractConver;
import com.javaoffers.brief.modelhelper.core.ConverDescriptor;
import com.javaoffers.brief.modelhelper.core.Register;
import java.lang.reflect.Method;

public class PrimitiveNumber2PrimitiveNumberConvert
extends AbstractConver<Number, Number> {
    ConverDescriptor descriptor;
    Method convertMethod;

    @Override
    public Number convert(Number number) {
        try {
            return (Number)this.convertMethod.invoke((Object)number, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void register(Register register) {
        Class[] basePrimitiveClass;
        for (Class src : basePrimitiveClass = ModelConsistants.basePrimitiveClass) {
            for (Class des : basePrimitiveClass) {
                try {
                    ConverDescriptor descriptor = new ConverDescriptor(ModelConsistants.numberPrimitivesMapping.get(src), ModelConsistants.numberPrimitivesMapping.get(des));
                    PrimitiveNumber2PrimitiveNumberConvert n2n = new PrimitiveNumber2PrimitiveNumberConvert();
                    n2n.setDescriptor(descriptor);
                    Method method = Number.class.getDeclaredMethod(des.getSimpleName() + "Value", new Class[0]);
                    n2n.setConvertMethod(method);
                    method.setAccessible(true);
                    register.registerConvert(descriptor, n2n);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void setDescriptor(ConverDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setConvertMethod(Method convertMethod) {
        this.convertMethod = convertMethod;
    }
}

