/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.core;

import com.javaoffers.brief.modelhelper.anno.internal.NotNull;
import com.javaoffers.brief.modelhelper.convert.AbstractConver;
import com.javaoffers.brief.modelhelper.convert.Convert;
import com.javaoffers.brief.modelhelper.core.ConverDescriptor;
import com.javaoffers.brief.modelhelper.core.ConvertDelegate;
import com.javaoffers.brief.modelhelper.core.ModelApplicationContext;
import com.javaoffers.brief.modelhelper.utils.BlurUtils;
import com.javaoffers.brief.modelhelper.utils.ReflectionUtils;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class ConvertRegisterSelectorDelegate {
    private ModelApplicationContext applicationContext = new ModelApplicationContext();
    public static final ConvertRegisterSelectorDelegate convert = new ConvertRegisterSelectorDelegate();
    public static final ThreadLocal<Class> processingConvertClass = new ThreadLocal();
    static Convert convertSame = new SameConvert();

    private ConvertRegisterSelectorDelegate() {
        Set converts = ReflectionUtils.getChilds(Convert.class);
        for (Class c : converts) {
            if (Modifier.isAbstract(c.getModifiers())) continue;
            try {
                if (c.isAssignableFrom(SameConvert.class)) continue;
                Constructor constructor = c.getConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.registerConvert((AbstractConver)constructor.newInstance(new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void registerConvert(AbstractConver convert) {
        convert.register(this.applicationContext);
    }

    private Convert selector(Class src, Class des) {
        Convert convert = this.applicationContext.selector(new ConverDescriptor(src, des));
        if (convert == null) {
            Iterator iterator;
            Set desSupers;
            Class srcc;
            Set srcSupers = Utils.getSupperClass((Class)src);
            Iterator iterator2 = srcSupers.iterator();
            while (iterator2.hasNext() && (convert = this.selectorOnly(srcc = (Class)iterator2.next(), des)) == null) {
            }
            if (convert == null) {
                Class dess;
                desSupers = ReflectionUtils.getChilds((Class)des);
                iterator = desSupers.iterator();
                while (iterator.hasNext() && (convert = this.selectorOnly(src, dess = (Class)iterator.next())) == null) {
                }
            }
            if (convert == null) {
                Class desSupper;
                desSupers = Utils.getSupperClass((Class)des);
                iterator = desSupers.iterator();
                while (iterator.hasNext() && (convert = this.selectorOnly(src, desSupper = (Class)iterator.next())) == null) {
                }
            }
            if (convert != null) {
                this.applicationContext.registerConvert(new ConverDescriptor(src, des), convert);
            }
        }
        return convert;
    }

    private Convert selectorOnly(Class src, Class des) {
        return this.applicationContext.selector(new ConverDescriptor(src, des));
    }

    private LinkedList<Class> getSupers(Class c) {
        Class superclass = c.getSuperclass();
        Class<?>[] interfaces = c.getInterfaces();
        LinkedList<Class> srcs = new LinkedList<Class>();
        if (superclass != Object.class && superclass != null) {
            Collections.addAll(srcs, superclass);
        }
        for (Class<?> srcInter : interfaces) {
            if (srcInter == null) continue;
            Collections.addAll(srcs, srcInter);
        }
        return srcs;
    }

    public <T> T converterObject(Class<T> des, Object srcValue, Field field) {
        try {
            Object t = this.converterObject(des, srcValue);
            Annotation anno = null;
            if (t instanceof String && StringUtils.isNotBlank((CharSequence)((String)t)) && (anno = Utils.getBlurAnnotation((Field)field)) != null) {
                t = BlurUtils.processDeriveAnno((Annotation)anno, (String)((String)t));
            }
            return t;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(e.getMessage() + " the field name is " + field.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T converterObject(Class<T> des, @NotNull Object srcValue) {
        Class src;
        Class orgDes = des;
        if ((des = Utils.baseClassUpgrade(des)) == (src = Utils.baseClassUpgrade(srcValue.getClass())) || des.isAssignableFrom(src)) {
            return (T)srcValue;
        }
        Convert convert = this.selector(srcValue.getClass(), des);
        if (convert == null) {
            throw new ClassCastException("Origin type:" + srcValue.getClass().getName() + " dont convert to  Target type: " + des.getName());
        }
        T desObject = null;
        try {
            processingConvertClass.set(orgDes);
            desObject = (T)convert.convert(src.cast(srcValue));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            processingConvertClass.remove();
        }
        return desObject;
    }

    public <S, T> ConvertDelegate<T> choseConverter(Class<T> des, S srcValue, Field field) {
        Class orgDes = des;
        des = Utils.baseClassUpgrade(des);
        Convert convert = null;
        Class srcUpgrade = Utils.baseClassUpgrade(srcValue.getClass());
        if (des == srcUpgrade || des.isAssignableFrom(srcUpgrade)) {
            convert = convertSame;
        } else {
            convert = this.selector(srcValue.getClass(), des);
            if (convert == null) {
                throw new ClassCastException("Origin type:" + srcValue.getClass().getName() + " dont convert to  Target type: " + des.getName());
            }
        }
        ConvertDelegate<Object> convertDelegate = new ConvertDelegate<Object>(srcUpgrade, orgDes, convert);
        Annotation anno = null;
        anno = Utils.getBlurAnnotation((Field)field);
        if (anno != null) {
            Annotation finalAnno = anno;
            convertDelegate.setAfterProcess(value -> {
                if (value instanceof String && StringUtils.isNotBlank((CharSequence)((String)value))) {
                    value = BlurUtils.processDeriveAnno((Annotation)finalAnno, (String)((String)value));
                }
                return value;
            });
        }
        return convertDelegate;
    }

    public <S, T> ConvertDelegate<T> choseConverter(Class<T> des, S srcValue) {
        Class orgDes = des;
        des = Utils.baseClassUpgrade(des);
        Convert convert = null;
        Class srcUpgrade = Utils.baseClassUpgrade(srcValue.getClass());
        if (des == srcUpgrade || des.isAssignableFrom(srcUpgrade)) {
            convert = convertSame;
        } else {
            convert = this.selector(srcValue.getClass(), des);
            if (convert == null) {
                throw new ClassCastException("Origin type:" + srcValue.getClass().getName() + " dont convert to  Target type: " + des.getName());
            }
        }
        ConvertDelegate convertDelegate = new ConvertDelegate(srcUpgrade, orgDes, convert);
        return convertDelegate;
    }

    public static Class getProcessingConvertDesClass() {
        return processingConvertClass.get();
    }

    static class SameConvert
    implements Convert<Object, Object> {
        SameConvert() {
        }

        @Override
        public Object convert(Object s) {
            return s;
        }
    }
}

