/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.parse;

import com.javaoffers.brief.modelhelper.jdbc.ResultSetExecutor;
import com.javaoffers.brief.modelhelper.parse.ModelParse;
import com.javaoffers.brief.modelhelper.parse.RealtimeModelParse;
import com.javaoffers.brief.modelhelper.parse.RealtimeSmartModelParse;
import com.javaoffers.brief.modelhelper.parse.SmartModelParse;
import com.javaoffers.brief.modelhelper.utils.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ModelParseUtils {
    static final int batch = 100;
    static final ModelParse modelParse = new SmartModelParse();
    static final RealtimeModelParse realtimeSmartModelParse = new RealtimeSmartModelParse();

    public static <E> List<E> converterMap2Model(Class<E> clazz, List<Map<String, Object>> listMap) {
        if (listMap.size() > 100) {
            List partition = Lists.partition(listMap, (int)100);
            List[] slot = new List[partition.size()];
            ArrayList resutl = new ArrayList();
            partition.parallelStream().forEach(list -> {
                slot[list.getPartitionIndex()] = modelParse.converterMap2Model(clazz, list.getList());
            });
            Arrays.stream(slot).forEach(resutl::addAll);
            return resutl;
        }
        return modelParse.converterMap2Model(clazz, listMap);
    }

    public static <E> List<E> converterResultSet2ModelForJoinSelect(Class<E> clazz, ResultSetExecutor rs) {
        return realtimeSmartModelParse.converterResultSet2ModelForJoinSelect(clazz, rs);
    }

    public static <E> List<E> converterResultSet2ModelForNormalSelect(Class<E> modelClass, ResultSetExecutor briefResultSetExecutor) {
        return realtimeSmartModelParse.converterResultSet2ModelForNormalSelect(modelClass, briefResultSetExecutor);
    }

    public static <E> void converterResultSet2ModelForJoinSelectStream(Class<E> clazz, ResultSetExecutor rs, Consumer<E> consumer) {
        realtimeSmartModelParse.converterResultSet2ModelForJoinSelectStream(clazz, rs, consumer);
    }

    public static <E> void converterResultSet2ModelForNormalSelectStream(Class<E> modelClass, ResultSetExecutor briefResultSetExecutor, Consumer<E> consumer) {
        realtimeSmartModelParse.converterResultSet2ModelForNormalSelectStream(modelClass, briefResultSetExecutor, consumer);
    }
}

