/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.parse;

import com.javaoffers.brief.modelhelper.core.ConvertDelegate;
import com.javaoffers.brief.modelhelper.core.ConvertRegisterSelectorDelegate;
import com.javaoffers.brief.modelhelper.exception.ParseModelException;
import com.javaoffers.brief.modelhelper.jdbc.ResultSetExecutor;
import com.javaoffers.brief.modelhelper.parse.RealtimeModelParse;
import com.javaoffers.brief.modelhelper.utils.ModelFieldInfo;
import com.javaoffers.brief.modelhelper.utils.ModelFieldInfoPosition;
import com.javaoffers.brief.modelhelper.utils.ModelInfo;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class RealtimeSmartModelParse
implements RealtimeModelParse {
    private static final ConvertRegisterSelectorDelegate convert = ConvertRegisterSelectorDelegate.convert;
    private static final ThreadLocal<Map<String, String>> tl = new ThreadLocal();
    private static final AtomicLong nextKey = new AtomicLong();
    private static final String ROOT_KEY = "";

    @Override
    public <E> List<E> converterResultSet2ModelForJoinSelect(Class<E> clazz, ResultSetExecutor rs) {
        try {
            return RealtimeSmartModelParse.buildModelForJoinSelect(clazz, rs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ParseModelException(e.getMessage());
        }
    }

    @Override
    public <E> List<E> converterResultSet2ModelForNormalSelect(Class<E> clazz, ResultSetExecutor rs) {
        return RealtimeSmartModelParse.buildModelForNormalSelect(clazz, rs);
    }

    @Override
    public <E> void converterResultSet2ModelForNormalSelectStream(Class<E> clazz, ResultSetExecutor rs, Consumer<E> consumer) {
        List colNames = rs.getColNames();
        ModelInfo modelInfo = TableHelper.getModelInfo(clazz);
        List ones = modelInfo.getOnesCol(colNames);
        while (rs.nextRow()) {
            Object o = modelInfo.newC();
            RealtimeSmartModelParse.buildDataForNormalSelect(rs, ones, o);
            consumer.accept(o);
        }
    }

    @Override
    public <E> void converterResultSet2ModelForJoinSelectStream(Class<E> clazz, ResultSetExecutor rs, Consumer<E> consumer) {
        HashMap<String, Object> tmpCache = new HashMap<String, Object>();
        ArrayList<Object> result = new ArrayList<Object>();
        List colNames = rs.getColNames();
        ModelInfo modelInfo = TableHelper.getModelInfo(clazz);
        List ones = modelInfo.getOnesColWithOneModel(colNames);
        List arrays = modelInfo.getArrays(colNames);
        List list = modelInfo.getList(colNames);
        List set = modelInfo.getSet(colNames);
        List unique = modelInfo.getUniqueCol(colNames);
        try {
            while (rs.nextRow()) {
                String keyStr = RealtimeSmartModelParse.getUniqueKey(ROOT_KEY, rs, unique);
                Object o = tmpCache.get(keyStr);
                if (o == null) {
                    result.forEach(e -> consumer.accept(e));
                    tmpCache.clear();
                    result.clear();
                    o = modelInfo.newC();
                    tmpCache.put(keyStr, o);
                    result.add(o);
                    RealtimeSmartModelParse.buildData(keyStr, rs, tmpCache, ones, arrays, list, set, o, true);
                    continue;
                }
                RealtimeSmartModelParse.buildData(keyStr, rs, tmpCache, ones, arrays, list, set, o, false);
            }
            result.forEach(e -> consumer.accept(e));
            tmpCache.clear();
            result.clear();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new ParseModelException(e2.getMessage());
        }
    }

    private static <E> List<E> buildModelForNormalSelect(Class<E> clazz, ResultSetExecutor rs) {
        ArrayList<Object> result = new ArrayList<Object>();
        List colNames = rs.getColNames();
        ModelInfo modelInfo = TableHelper.getModelInfo(clazz);
        List ones = modelInfo.getOnesCol(colNames);
        while (rs.nextRow()) {
            Object o = modelInfo.newC();
            result.add(o);
            RealtimeSmartModelParse.buildDataForNormalSelect(rs, ones, o);
        }
        return result;
    }

    private static <E> void buildDataForNormalSelect(ResultSetExecutor rs, List<ModelFieldInfoPosition> ones, E model) {
        for (ModelFieldInfoPosition one : ones) {
            if (one.isModelClass()) continue;
            Object o = null;
            o = rs.getColValueByColPosition(one.getPosition());
            if (o == null) continue;
            ModelFieldInfo mfi = one.getModelFieldInfo();
            Object o1 = RealtimeSmartModelParse.convert(mfi, o);
            mfi.getSetter().setter(model, o1);
        }
    }

    private static Object convert(ModelFieldInfo one, Object o) {
        ConvertDelegate convertProxy = one.getConvertProxy();
        if (convertProxy == null) {
            convertProxy = convert.choseConverter(one.getFieldGenericClass(), o, one.getField());
            one.setConvertProxy(convertProxy);
        }
        Object o1 = convertProxy.convert(o);
        return o1;
    }

    private static <E> List<E> buildModelForJoinSelect(Class<E> clazz, ResultSetExecutor rs) throws Exception {
        HashMap<String, Object> tmpCache = new HashMap<String, Object>();
        ArrayList result = new ArrayList();
        List colNames = rs.getColNames();
        ModelInfo modelInfo = TableHelper.getModelInfo(clazz);
        List ones = modelInfo.getOnesColWithOneModel(colNames);
        List arrays = modelInfo.getArrays(colNames);
        List list = modelInfo.getList(colNames);
        List set = modelInfo.getSet(colNames);
        List unique = modelInfo.getUniqueCol(colNames);
        while (rs.nextRow()) {
            String keyStr = RealtimeSmartModelParse.getUniqueKey(ROOT_KEY, rs, unique);
            Object o = tmpCache.get(keyStr);
            if (o == null) {
                o = modelInfo.newC();
                tmpCache.put(keyStr, o);
                result.add(o);
                RealtimeSmartModelParse.buildData(keyStr, rs, tmpCache, ones, arrays, list, set, o, true);
                continue;
            }
            RealtimeSmartModelParse.buildData(keyStr, rs, tmpCache, ones, arrays, list, set, o, false);
        }
        return result;
    }

    private static String getUniqueKey(String parentKey, ResultSetExecutor rs, List<ModelFieldInfoPosition> unique) {
        if (unique.size() == 0) {
            return String.valueOf(nextKey.getAndIncrement());
        }
        StringBuilder key = new StringBuilder(parentKey);
        unique.forEach(modelFieldInfoPosition -> {
            int position = modelFieldInfoPosition.getPosition();
            Object o = rs.getColValueByColPosition(position);
            key.append(modelFieldInfoPosition.getModelFieldInfo().getAliasName());
            key.append(":");
            key.append(Objects.hashCode(o));
        });
        return key.toString();
    }

    private static <E> void buildData(String parentKey, ResultSetExecutor rs, Map<String, Object> tmpCache, List<ModelFieldInfoPosition> ones, List<ModelFieldInfo> arrays, List<ModelFieldInfo> list_, List<ModelFieldInfo> set_, E model, boolean processNoneModelField) throws Exception {
        Object o;
        String uniqueKey;
        List colNames;
        ModelInfo modelInfo;
        Class modelClassOfField;
        for (ModelFieldInfoPosition mif : ones) {
            ModelFieldInfo one = mif.getModelFieldInfo();
            if (one.isModelClass()) {
                modelClassOfField = one.getModelClassOfField();
                modelInfo = TableHelper.getModelInfo((Class)modelClassOfField);
                uniqueKey = RealtimeSmartModelParse.getUniqueKey(parentKey, rs, modelInfo.getUniqueCol(colNames = rs.getColNames()));
                o = tmpCache.get(uniqueKey);
                if (o == null) {
                    o = modelInfo.newC();
                    tmpCache.put(uniqueKey, o);
                    one.getSetter().setter(model, o);
                    RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, true);
                    continue;
                }
                RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, false);
                continue;
            }
            if (!processNoneModelField) continue;
            Object o2 = null;
            o2 = rs.getColValueByColPosition(mif.getPosition());
            if (o2 == null) continue;
            o2 = RealtimeSmartModelParse.convert(one, o2);
            one.getSetter().setter(model, o2);
        }
        for (ModelFieldInfo arrayField : arrays) {
            List colNames2;
            Class modelClassOfField2 = arrayField.getModelClassOfField();
            ModelInfo modelInfo2 = TableHelper.getModelInfo((Class)modelClassOfField2);
            String uniqueKey2 = RealtimeSmartModelParse.getUniqueKey(parentKey, rs, modelInfo2.getUniqueCol(colNames2 = rs.getColNames()));
            Object o3 = tmpCache.get(uniqueKey2);
            if (o3 == null) {
                o3 = modelInfo2.newC();
                tmpCache.put(uniqueKey2, o3);
                Object arrayObj = arrayField.getGetter().getter(model);
                if (arrayObj == null) {
                    arrayObj = Array.newInstance(modelClassOfField2, 1);
                    Array.set(arrayObj, 0, o3);
                    arrayField.getSetter().setter(model, arrayObj);
                } else {
                    int len = Array.getLength(arrayObj);
                    Object newArrayObj = Array.newInstance(modelClassOfField2, len + 1);
                    System.arraycopy(arrayObj, 0, newArrayObj, 0, len);
                    Array.set(newArrayObj, len, o3);
                    arrayField.getSetter().setter(model, newArrayObj);
                }
                RealtimeSmartModelParse.buildData(uniqueKey2, rs, tmpCache, modelInfo2.getOnesColWithOneModel(colNames2), modelInfo2.getArrays(colNames2), modelInfo2.getList(colNames2), modelInfo2.getSet(colNames2), o3, true);
                continue;
            }
            RealtimeSmartModelParse.buildData(uniqueKey2, rs, tmpCache, modelInfo2.getOnesColWithOneModel(colNames2), modelInfo2.getArrays(colNames2), modelInfo2.getList(colNames2), modelInfo2.getSet(colNames2), o3, false);
        }
        for (ModelFieldInfo listField : list_) {
            List listFieldValue = (List)listField.getGetter().getter(model);
            if (listFieldValue == null) {
                listFieldValue = (List)listField.getNewc();
                listField.getSetter().setter(model, (Object)listFieldValue);
            }
            if ((o = tmpCache.get(uniqueKey = RealtimeSmartModelParse.getUniqueKey(parentKey, rs, (modelInfo = TableHelper.getModelInfo((Class)(modelClassOfField = listField.getModelClassOfField()))).getUniqueCol(colNames = rs.getColNames())))) == null) {
                o = modelInfo.newC();
                tmpCache.put(uniqueKey, o);
                RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, true);
                listFieldValue.add(o);
                continue;
            }
            RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, false);
        }
        for (ModelFieldInfo setField : set_) {
            Set setFieldValue = (Set)setField.getGetter().getter(model);
            if (setFieldValue == null) {
                setFieldValue = (Set)setField.getNewc();
                setField.getSetter().setter(model, (Object)setFieldValue);
            }
            if ((o = tmpCache.get(uniqueKey = RealtimeSmartModelParse.getUniqueKey(parentKey, rs, (modelInfo = TableHelper.getModelInfo((Class)(modelClassOfField = setField.getModelClassOfField()))).getUniqueCol(colNames = rs.getColNames())))) == null) {
                o = modelInfo.newC();
                tmpCache.put(uniqueKey, o);
                RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, true);
                continue;
            }
            RealtimeSmartModelParse.buildData(uniqueKey, rs, tmpCache, modelInfo.getOnesColWithOneModel(colNames), modelInfo.getArrays(colNames), modelInfo.getList(colNames), modelInfo.getSet(colNames), o, false);
        }
    }
}

