/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.parse;

import com.javaoffers.brief.modelhelper.core.ConvertRegisterSelectorDelegate;
import com.javaoffers.brief.modelhelper.exception.BaseException;
import com.javaoffers.brief.modelhelper.parse.ModelParse;
import com.javaoffers.brief.modelhelper.util.HelperUtils;
import com.javaoffers.brief.modelhelper.util.Model;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.TableHelper;
import com.javaoffers.brief.modelhelper.utils.TableInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class SmartModelParse
implements ModelParse {
    private static final ConvertRegisterSelectorDelegate convert = ConvertRegisterSelectorDelegate.convert;
    private static final ThreadLocal<Map<String, String>> tl = new ThreadLocal();

    @Override
    public <E> List<E> converterMap2Model(Class<E> clazz, List<Map<String, Object>> listMap) {
        if (listMap == null || listMap.size() == 0) {
            return new ArrayList();
        }
        if (HelperUtils.isBaseModel(clazz)) {
            try {
                return SmartModelParse.buildModel(clazz, listMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private static <E> List<E> buildModel(Class<E> clazz, List<Map<String, Object>> list_map) throws Exception {
        ArrayList<E> resultList = new ArrayList<E>();
        if (clazz == null || list_map == null || list_map.size() == 0) {
            return resultList;
        }
        LinkedHashMap<String, List<Map<String, Object>>> map_ = new LinkedHashMap<String, List<Map<String, Object>>>();
        Set<Field> fields = HelperUtils.getFields(clazz);
        ArrayList<Field> ones = new ArrayList<Field>();
        ArrayList<Field> arrays = new ArrayList<Field>();
        ArrayList<Field> list_ = new ArrayList<Field>();
        ArrayList<Field> set_ = new ArrayList<Field>();
        for (Field fd : fields) {
            if (fd.getType().isArray()) {
                arrays.add(fd);
                continue;
            }
            if (List.class.isAssignableFrom(fd.getType())) {
                list_.add(fd);
                continue;
            }
            if (Set.class.isAssignableFrom(fd.getType())) {
                set_.add(fd);
                continue;
            }
            ones.add(fd);
        }
        TableInfo tableInfo = TableHelper.getTableInfo(clazz);
        String tableName = tableInfo.getTableName();
        DBType dbType = tableInfo.getDbType();
        ArrayList<String> uniqueFieldNameList = new ArrayList<String>();
        HelperUtils.getUniqueFieldNames(clazz, tableName, dbType, ones, uniqueFieldNameList, list_map.get(0));
        if (uniqueFieldNameList == null || uniqueFieldNameList.size() == 0) {
            return resultList;
        }
        HelperUtils.inciseData(list_map, map_, uniqueFieldNameList);
        List<E> list = SmartModelParse.buildData(tableName, dbType, clazz, map_, ones, arrays, list_, set_);
        resultList.addAll(list);
        return resultList;
    }

    private static <E> List<E> buildData(String tableName, DBType dbType, Class<E> clazz, Map<String, List<Map<String, Object>>> map_, ArrayList<Field> ones, ArrayList<Field> arrays, ArrayList<Field> list_, ArrayList<Field> set_) throws Exception {
        ArrayList resultList = new ArrayList();
        Set<Map.Entry<String, List<Map<String, Object>>>> entrySet = map_.entrySet();
        for (Map.Entry<String, List<Map<String, Object>>> entry : entrySet) {
            Collection newInstance;
            Collection ls;
            Class<?> type;
            String name;
            List<E> ls2;
            List<Map<String, Object>> list = entry.getValue();
            if (list == null || list.size() == 0) continue;
            Map<String, Object> mp = list.get(0);
            Model model = Model.getModel(clazz.newInstance());
            for (Field fd : ones) {
                if (HelperUtils.isBaseModel(fd)) {
                    ls2 = SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list);
                    if (ls2 == null || ls2.size() != 1) continue;
                    E object = ls2.get(0);
                    fd.set(model.getModelAndSetStatusIsTrue(), object);
                    continue;
                }
                name = HelperUtils.getSpecialColName(tableName, dbType, fd.getName());
                Object o = null;
                o = mp.get(name);
                if (o == null && (o = mp.get(fd.getName())) == null && (o = mp.get(HelperUtils.getSpecialColName(clazz, fd))) == null) continue;
                Class<?> type2 = fd.getType();
                Object object2 = convert.converterObject(type2, o, fd);
                fd.set(model.getModelAndSetStatusIsTrue(), object2);
            }
            for (Field fd : arrays) {
                Object object;
                if (HelperUtils.isBaseModel(fd)) {
                    ls2 = SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list);
                    if (ls2 == null || ls2.isEmpty() || ls2.size() <= 0) continue;
                    Class<?> class1 = ls2.get(0).getClass();
                    Object object2 = Array.newInstance(class1, ls2.size());
                    for (int i = 0; i < ls2.size(); ++i) {
                        Array.set(object2, i, ls2.get(i));
                    }
                    if (object2 == null) continue;
                    fd.set(model.getModelAndSetStatusIsTrue(), object2);
                    continue;
                }
                name = HelperUtils.getSpecialColName(tableName, dbType, fd.getName());
                ArrayList<Object> arrayData = new ArrayList<Object>();
                for (Map<String, Object> map : list) {
                    object = map.get(name);
                    if (object == null) {
                        object = map.get(fd.getName());
                    }
                    if (object == null) {
                        object = map.get(HelperUtils.getSpecialColName(clazz, fd));
                    }
                    if (object == null) continue;
                    arrayData.add(object);
                }
                String typeName = fd.getGenericType().getTypeName();
                Class<?> originClass = Class.forName(typeName.substring(0, typeName.length() - 2));
                object = Array.newInstance(originClass, arrayData.size());
                if (arrayData == null || arrayData.size() <= 0) continue;
                for (int i = 0; i < arrayData.size(); ++i) {
                    Object object2 = convert.converterObject(originClass.getClass(), arrayData.get(i), fd);
                    Array.set(object, i, object2);
                }
                fd.set(model.getModelAndSetStatusIsTrue(), object);
            }
            for (Field fd : list_) {
                type = fd.getType();
                ls = Collections.EMPTY_LIST;
                if (type.isInterface()) {
                    ls = HelperUtils.isBaseModel(fd) ? SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list) : SmartModelParse.getList(clazz, tableName, dbType, list, fd);
                } else {
                    ls = HelperUtils.isBaseModel(fd) ? SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list) : SmartModelParse.getList(clazz, tableName, dbType, list, fd);
                    newInstance = (List)fd.get(model.getModelAndSetStatusIsTrue());
                    if (newInstance == null) {
                        newInstance = (List)type.newInstance();
                    }
                    newInstance.addAll(ls);
                    ls = newInstance;
                }
                if (ls == null || ls.size() <= 0) continue;
                fd.set(model.getModelAndSetStatusIsTrue(), ls);
            }
            for (Field fd : set_) {
                type = fd.getType();
                ls = Collections.EMPTY_LIST;
                newInstance = Collections.EMPTY_SET;
                if (type.isInterface()) {
                    ls = HelperUtils.isBaseModel(fd) ? SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list) : SmartModelParse.getList(clazz, tableName, dbType, list, fd);
                    newInstance = new HashSet();
                    newInstance.addAll(ls);
                } else {
                    ls = HelperUtils.isBaseModel(fd) ? SmartModelParse.buildModel(HelperUtils.getModelClass(fd), list) : SmartModelParse.getList(clazz, tableName, dbType, list, fd);
                    newInstance = (Set)fd.get(model.getModelAndSetStatusIsTrue());
                    if (newInstance == null) {
                        newInstance = (Set)type.newInstance();
                    }
                    newInstance.addAll(ls);
                }
                if (newInstance == null || newInstance.size() <= 0) continue;
                fd.set(model.getModelAndSetStatusIsTrue(), newInstance);
            }
            if (!model.isStatus()) continue;
            resultList.add(model.getModel());
        }
        return resultList;
    }

    private static List getList(Class mClass, String tableName, DBType dbType, List<Map<String, Object>> list, Field fd) throws ClassNotFoundException {
        ArrayList ls;
        Class gClass = HelperUtils.getGenericityClassOfCollect(fd);
        ArrayList finalLs = ls = new ArrayList();
        list.forEach(map -> {
            Object o = map.get(HelperUtils.getSpecialColName(tableName, dbType, fd.getName()));
            if (o == null) {
                o = map.get(fd.getName());
            }
            if (o == null) {
                o = map.get(HelperUtils.getSpecialColName(mClass, fd));
            }
            finalLs.add(convert.converterObject(gClass, o, fd));
        });
        return ls;
    }

    @Deprecated
    private static <E> void checkIsExistsSameSuperModel(Class<E> clazz) {
        Map<String, String> map = tl.get();
        String name = clazz.getSuperclass().getName();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if ("java.lang.Object".equals(name)) {
            return;
        }
        String superName = map.get(name);
        if (StringUtils.isNotBlank((CharSequence)superName)) {
            throw new BaseException("Model models cannot have the same parent class to prevent field duplication! !" + clazz.getName());
        }
        map.put(name, name);
    }
}

