/*
 * Decompiled with CFR 0.152.
 */
package com.javaoffers.brief.modelhelper.util;

import com.javaoffers.brief.modelhelper.anno.BaseUnique;
import com.javaoffers.brief.modelhelper.core.ConvertRegisterSelectorDelegate;
import com.javaoffers.brief.modelhelper.utils.DBType;
import com.javaoffers.brief.modelhelper.utils.Utils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelperUtils {
    static Logger logger = LoggerFactory.getLogger(HelperUtils.class);
    static final String modelSeparation = "__";
    private static final ConvertRegisterSelectorDelegate convert = ConvertRegisterSelectorDelegate.convert;

    @Deprecated
    public static List<Map<String, Object>> initData(List<Map<String, Object>> list_map) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (list_map != null && list_map.size() > 0) {
            for (Map<String, Object> data : list_map) {
                HashMap<String, Object> newData = new HashMap<String, Object>();
                Set<Map.Entry<String, Object>> entries = data.entrySet();
                for (Map.Entry<String, Object> entry : entries) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    String[] split = key.split("_");
                    StringBuilder sb = new StringBuilder("");
                    for (int i = 0; split != null && i < split.length; ++i) {
                        if (i == 0) {
                            String firstChar = split[i];
                            sb.append(firstChar);
                            continue;
                        }
                        String nextChar = split[i];
                        String upperCase = nextChar.substring(0, 1).toUpperCase();
                        sb.append(upperCase);
                        if (nextChar.length() <= 1) continue;
                        String substring = nextChar.substring(1);
                        sb.append(substring);
                    }
                    String newKey = sb.toString();
                    newData.put(newKey, value);
                }
                if (newData == null || newData.isEmpty()) continue;
                list.add(newData);
            }
        }
        return list;
    }

    public static Class getModelClass(Field fd) throws Exception {
        return Utils.getModelClass((Field)fd);
    }

    public static Class getGenericityClass(Field fd) throws Exception {
        return Utils.getGenericityClass((Field)fd);
    }

    public static Class getGenericityClassOfCollect(Field fd) throws ClassNotFoundException {
        return Utils.getGenericityClassOfCollect((Field)fd);
    }

    public static <E> Set<Field> getFields(Class<E> clazz) {
        return Utils.getFields(clazz);
    }

    public static void getUniqueFieldNames(Class mClass, String tableName, DBType dbType, ArrayList<Field> ones, ArrayList<String> uniqueFieldNameList_, Map<String, Object> standardClumMap) throws SecurityException, Exception {
        Set<Object> hashSet = new HashSet();
        for (Field fd : ones) {
            if (HelperUtils.isBaseModel(fd)) {
                Field[] bmFs = fd.getType().getDeclaredFields();
                for (int i = 0; bmFs != null && i < bmFs.length; ++i) {
                    Field bmf = bmFs[i];
                    BaseUnique[] uniques = (BaseUnique[])bmf.getAnnotationsByType(BaseUnique.class);
                    if (uniques == null || uniques.length <= 0) continue;
                    String name = bmf.getName();
                    String uniqueFieldName = HelperUtils.getSpecialColName(tableName, dbType, name);
                    if (standardClumMap.containsKey(uniqueFieldName)) {
                        hashSet.add(uniqueFieldName);
                        continue;
                    }
                    if (standardClumMap.containsKey(name)) {
                        hashSet.add(name);
                        continue;
                    }
                    uniqueFieldName = HelperUtils.getSpecialColName(mClass, bmf);
                    if (!standardClumMap.containsKey(uniqueFieldName)) continue;
                    hashSet.add(uniqueFieldName);
                }
            }
            if (!HelperUtils.isBaseUnique(fd)) continue;
            String name = fd.getName();
            String uniqueFieldName = HelperUtils.getSpecialColName(tableName, dbType, name);
            if (standardClumMap.containsKey(uniqueFieldName)) {
                hashSet.add(uniqueFieldName);
                continue;
            }
            if (standardClumMap.containsKey(name)) {
                hashSet.add(name);
                continue;
            }
            uniqueFieldName = HelperUtils.getSpecialColName(mClass, fd);
            if (!standardClumMap.containsKey(uniqueFieldName)) continue;
            hashSet.add(uniqueFieldName);
        }
        if (hashSet.size() == 0) {
            hashSet = ones.stream().map(field -> {
                String name = field.getName();
                String uniqueFieldName = HelperUtils.getSpecialColName(tableName, dbType, name);
                if (standardClumMap.containsKey(uniqueFieldName)) {
                    return uniqueFieldName;
                }
                if (standardClumMap.containsKey(name)) {
                    return name;
                }
                uniqueFieldName = HelperUtils.getSpecialColName(mClass, field);
                if (standardClumMap.containsKey(uniqueFieldName)) {
                    return uniqueFieldName;
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        uniqueFieldNameList_.addAll(hashSet);
    }

    public static String getSpecialColName(String tableName, DBType dbType, String colName) {
        return Utils.getSpecialColName((String)tableName, (DBType)dbType, (String)colName);
    }

    public static String getSpecialColName(Class mClass, Field fd) {
        return mClass.getSimpleName() + fd.getName();
    }

    public static boolean isInstanceOfCharSequenceOrNumber(Class c) {
        return CharSequence.class.isAssignableFrom(c) || Number.class.isAssignableFrom(c);
    }

    public static boolean isBaseModel(Field fd) throws Exception {
        return Utils.isBaseModel((Field)fd);
    }

    public static boolean isBaseModel(Class fd) {
        return Utils.isBaseModel((Class)fd);
    }

    public static boolean isBaseUnique(Field fd) {
        BaseUnique[] bm = (BaseUnique[])fd.getAnnotationsByType(BaseUnique.class);
        return bm != null && bm.length > 0;
    }

    public static void inciseData(List<Map<String, Object>> list_map, Map<String, List<Map<String, Object>>> map_, ArrayList<String> uniqueFieldNameList) {
        for (Map<String, Object> m : list_map) {
            StringBuilder sb = new StringBuilder("_");
            for (int i = 0; uniqueFieldNameList != null && i < uniqueFieldNameList.size(); ++i) {
                String uniqueKey = uniqueFieldNameList.get(i);
                String uniqueValue = m.get(uniqueKey) == null ? "" : convert.converterObject(String.class, m.get(uniqueKey));
                sb.append(uniqueValue);
            }
            List<Map<String, Object>> dataList = map_.get(sb.toString());
            if (dataList == null) {
                dataList = new LinkedList<Map<String, Object>>();
                map_.put(sb.toString(), dataList);
            }
            dataList.add(m);
        }
    }

    public static List<Class> parseAllModelClass(Class clazz) {
        return Utils.parseAllModelClass((Class)clazz);
    }
}

