/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.ConstrainedVariable;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.AbstractConstraint;

public class Constraint
extends AbstractConstraint {
    String oper;
    double[] coefficients = null;
    ConstrainedVariable[] vars = null;
    double value;
    ConstrainedVariable derivedVar = null;

    public Constraint(Problem problem) {
        super(problem);
        int count = problem.getConstraints().length;
        String name = "C" + (count + 1);
        this.setName(name);
    }

    public double[] getCoefficients() {
        return this.coefficients;
    }

    public void setCoefficients(int[] coefficients) {
        double[] darray = new double[coefficients.length];
        for (int i = 0; i < darray.length; ++i) {
            darray[i] = coefficients[i];
        }
        this.coefficients = darray;
    }

    public void setCoefficients(double[] coefficients) {
        this.coefficients = coefficients;
    }

    public void negateCoefficients() {
        for (int i = 0; i < this.coefficients.length; ++i) {
            this.coefficients[i] = -this.coefficients[i];
        }
    }

    public ConstrainedVariable[] getVars() {
        return this.vars;
    }

    public void setVars(ConstrainedVariable[] vars) {
        this.vars = vars;
    }

    public void setVars(Var[] vars) {
        ConstrainedVariable[] acvars = new ConstrainedVariable[vars.length];
        for (int i = 0; i < acvars.length; ++i) {
            acvars[i] = (AbstractConstrainedVariable)vars[i];
        }
        this.vars = acvars;
    }

    public void setVars(VarReal[] vars) {
        ConstrainedVariable[] acvars = new ConstrainedVariable[vars.length];
        for (int i = 0; i < acvars.length; ++i) {
            acvars[i] = (AbstractConstrainedVariable)vars[i];
        }
        this.vars = acvars;
    }

    public String getOper() {
        return this.oper;
    }

    public void setOper(String oper) {
        this.oper = oper;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public ConstrainedVariable getDerivedVar() {
        return this.derivedVar;
    }

    public void setDerivedVar(ConstrainedVariable derivedVar) {
        this.derivedVar = derivedVar;
    }
}

