/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.constraints.ConstrainedVariable;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarBool;
import javax.constraints.VarReal;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.Constraint;
import javax.constraints.linear.LinearSolver;
import javax.constraints.linear.LinearSolverFactory;
import javax.constraints.linear.NonLinearProblemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Problem
extends AbstractProblem {
    public static final String JSR331_LINEAR_VERSION = "JSR-331 Common Implementation for Linear Solvers";
    int numberOfScalProducts = 0;
    private static Logger logger = LoggerFactory.getLogger((String)"javax.constraints");

    public Problem() {
        this("LinearProblem");
    }

    public Problem(String name) {
        super(name);
    }

    public javax.constraints.Constraint postElement(int[] array, Var indexVar, String oper, int value) {
        throw new NonLinearProblemException("postElement(int[] coefficients, Var indexVar, String oper, int value)");
    }

    public javax.constraints.Constraint postElement(int[] array, Var indexVar, String oper, Var var) {
        throw new NonLinearProblemException("postElement(int[] coefficients, Var indexVar, String oper, Var var)");
    }

    public javax.constraints.Constraint postElement(Var[] vars, Var indexVar, String oper, int value) {
        throw new NonLinearProblemException("postElement(Var[] vars, Var indexVar, String oper, int value) ");
    }

    public javax.constraints.Constraint postElement(Var[] vars, Var indexVar, String oper, Var var) {
        throw new NonLinearProblemException("postElement(Var[] vars, Var indexVar, String oper, Var var)");
    }

    public javax.constraints.Constraint post(int[] coefficients, Var[] vars, String oper, int value) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        Constraint constraint = new Constraint((javax.constraints.Problem)this);
        constraint.setCoefficients(coefficients);
        constraint.setVars(vars);
        constraint.setOper(oper);
        constraint.setValue(value);
        this.add((javax.constraints.Constraint)constraint);
        return constraint;
    }

    public javax.constraints.Constraint post(int[] coefficients, Var[] vars, String oper, Var var) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        Var[] vars1 = new Var[vars.length + 1];
        int[] coefs = new int[vars.length + 1];
        for (int i = 0; i < vars.length; ++i) {
            vars1[i] = vars[i];
            coefs[i] = coefficients[i];
        }
        vars1[vars.length] = var;
        coefs[vars.length] = -1;
        int value = 0;
        return this.post(coefs, vars1, oper, value);
    }

    public javax.constraints.Constraint post(Var[] vars, String oper, int value) {
        int[] coefs = new int[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            coefs[i] = 1;
        }
        return this.post(coefs, vars, oper, value);
    }

    public javax.constraints.Constraint post(Var[] vars, String oper, Var var) {
        Var[] vars1 = new Var[vars.length + 1];
        int[] coefs = new int[vars.length + 1];
        for (int i = 0; i < vars.length; ++i) {
            vars1[i] = vars[i];
            coefs[i] = 1;
        }
        vars1[vars.length] = var;
        coefs[vars.length] = -1;
        int value = 0;
        return this.post(coefs, vars1, oper, value);
    }

    public javax.constraints.Constraint post(Var var, String oper, int value) {
        Var[] vars = new Var[]{var};
        return this.post(vars, oper, value);
    }

    public javax.constraints.Constraint post(Var var1, String oper, Var var2) {
        Var[] vars = new Var[]{var1, var2};
        int[] coefficients = new int[]{1, -1};
        int value = 0;
        return this.post(coefficients, vars, oper, value);
    }

    public javax.constraints.Constraint linear(Var var, String oper, int value) {
        Constraint constraint = new Constraint((javax.constraints.Problem)this);
        constraint.setCoefficients(new int[]{1});
        constraint.setVars(new Var[]{var});
        constraint.setOper(oper);
        constraint.setValue(value);
        return constraint;
    }

    public javax.constraints.Constraint linear(Var var1, String oper, Var var2) {
        Constraint constraint = new Constraint((javax.constraints.Problem)this);
        constraint.setCoefficients(new int[]{1, -1});
        constraint.setVars(new Var[]{var1, var2});
        constraint.setOper(oper);
        constraint.setValue(0.0);
        return constraint;
    }

    public javax.constraints.Constraint post(double[] coefficients, Var[] vars, String oper, double value) {
        return this.post(coefficients, (ConstrainedVariable[])vars, oper, value);
    }

    public javax.constraints.Constraint post(double[] coefficients, VarReal[] vars, String oper, double value) {
        return this.post(coefficients, (ConstrainedVariable[])vars, oper, value);
    }

    public javax.constraints.Constraint post(double[] coefficients, ConstrainedVariable[] vars, String oper, double value) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        Constraint constraint = new Constraint((javax.constraints.Problem)this);
        constraint.setCoefficients(coefficients);
        constraint.setVars(vars);
        constraint.setOper(oper);
        constraint.setValue(value);
        this.add((javax.constraints.Constraint)constraint);
        return constraint;
    }

    public javax.constraints.Constraint post(double[] coefficients, VarReal[] vars, String oper, VarReal var) {
        return this.post(coefficients, (ConstrainedVariable[])vars, oper, (ConstrainedVariable)var);
    }

    public javax.constraints.Constraint post(double[] coefficients, ConstrainedVariable[] vars, String oper, ConstrainedVariable var) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        ConstrainedVariable[] vars1 = new ConstrainedVariable[vars.length + 1];
        double[] coefs = new double[vars.length + 1];
        for (int i = 0; i < vars.length; ++i) {
            vars1[i] = vars[i];
            coefs[i] = coefficients[i];
        }
        vars1[vars.length] = var;
        coefs[vars.length] = -1.0;
        boolean value = false;
        return this.post(coefs, vars1, oper, (double)value);
    }

    public javax.constraints.Constraint post(VarReal[] vars, String oper, double value) {
        double[] coefs = new double[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            coefs[i] = 1.0;
        }
        return this.post(coefs, vars, oper, value);
    }

    public javax.constraints.Constraint post(VarReal[] vars, String oper, int value) {
        return this.post(vars, oper, (double)value);
    }

    public javax.constraints.Constraint post(VarReal[] vars, String oper, VarReal var) {
        VarReal[] vars1 = new VarReal[vars.length + 1];
        double[] coefs = new double[vars.length + 1];
        for (int i = 0; i < vars.length; ++i) {
            vars1[i] = vars[i];
            coefs[i] = 1.0;
        }
        vars1[vars.length] = var;
        coefs[vars.length] = -1.0;
        double value = 0.0;
        return this.post(coefs, vars1, oper, value);
    }

    public javax.constraints.Constraint post(VarReal var, String oper, double value) {
        VarReal[] vars = new VarReal[]{var};
        return this.post(vars, oper, value);
    }

    public javax.constraints.Constraint post(VarReal var, String oper, int value) {
        return this.post(var, oper, (double)value);
    }

    public javax.constraints.Constraint post(VarReal var1, String oper, VarReal var2) {
        VarReal[] vars = new VarReal[]{var1, var2};
        double[] coefficients = new double[]{1.0, -1.0};
        double value = 0.0;
        return this.post(coefficients, vars, oper, value);
    }

    public javax.constraints.Constraint post(VarReal var1, String oper, Var var2) {
        return this.post(var1, oper, var2.asReal());
    }

    public javax.constraints.Constraint post(Var var1, String oper, VarReal var2) {
        return this.post(var1.asReal(), oper, var2);
    }

    public javax.constraints.Constraint postScalProd(Var var, String oper, int[] coefficients, Var[] vars) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("postScalProd: arrays of coefficients and vars should have the same length");
        }
        int[] coefPlus1 = new int[coefficients.length + 1];
        Var[] varsPlus1 = new Var[vars.length + 1];
        for (int i = 0; i < vars.length; ++i) {
            coefPlus1[i] = coefficients[i];
            varsPlus1[i] = vars[i];
        }
        coefPlus1[coefficients.length] = -1;
        varsPlus1[vars.length] = var;
        Constraint c = (Constraint)this.post(coefPlus1, varsPlus1, oper, 0);
        c.setDerivedVar((ConstrainedVariable)var);
        return c;
    }

    public Var scalProd(int[] coefficients, Var[] vars) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        int positiveMin = 0;
        int positiveMax = 0;
        int maxPositiveValue = 0;
        boolean areNegatives = false;
        for (int i = 0; i < vars.length; ++i) {
            int prod;
            if (coefficients[i] < 0) {
                areNegatives = true;
            }
            if (vars[i].getMin() < 0) {
                areNegatives = true;
            }
            if (maxPositiveValue < (prod = Math.abs(coefficients[i] * vars[i].getMax()))) {
                maxPositiveValue = prod;
            }
            positiveMin += vars[i].getMin() * coefficients[i];
            positiveMax += vars[i].getMax() * coefficients[i];
        }
        int min = positiveMin;
        int max = positiveMax;
        if (areNegatives) {
            max = maxPositiveValue * vars.length;
            min = -max;
        }
        int n = this.getConstraints().length;
        ++this.numberOfScalProducts;
        Var derivedVar = this.createVariable("_ScalProd" + this.numberOfScalProducts, min, max);
        this.postScalProd(derivedVar, "=", coefficients, vars);
        this.remove("_ScalProd");
        return derivedVar;
    }

    public Var scalProd(String name, int[] coefficients, Var[] vars) {
        if (coefficients.length != vars.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        int positiveMin = 0;
        int positiveMax = 0;
        int maxPositiveValue = 0;
        boolean areNegatives = false;
        for (int i = 0; i < vars.length; ++i) {
            int prod;
            if (coefficients[i] < 0) {
                areNegatives = true;
            }
            if (vars[i].getMin() < 0) {
                areNegatives = true;
            }
            if (maxPositiveValue < (prod = Math.abs(coefficients[i] * vars[i].getMax()))) {
                maxPositiveValue = prod;
            }
            positiveMin += vars[i].getMin() * coefficients[i];
            positiveMax += vars[i].getMax() * coefficients[i];
        }
        int min = positiveMin;
        int max = positiveMax;
        if (areNegatives) {
            max = maxPositiveValue * vars.length;
            min = -max;
        }
        int n = this.getConstraints().length;
        Var derivedVar = this.createVariable(name, min, max);
        this.add(name, derivedVar);
        this.postScalProd(derivedVar, "=", coefficients, vars);
        return derivedVar;
    }

    public VarReal scalProd(double[] arrayOfValues, VarReal[] arrayOfVariables) {
        VarReal derivedVar;
        if (arrayOfValues.length != arrayOfVariables.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        double positiveMin = 0.0;
        double positiveMax = 0.0;
        double maxPositiveValue = 0.0;
        boolean areNegatives = false;
        double[] coefPlus1 = new double[arrayOfValues.length + 1];
        VarReal[] varsPlus1 = new VarReal[arrayOfVariables.length + 1];
        for (int i = 0; i < arrayOfVariables.length; ++i) {
            double prod;
            coefPlus1[i] = arrayOfValues[i];
            varsPlus1[i] = arrayOfVariables[i];
            if (arrayOfValues[i] < 0.0) {
                areNegatives = true;
            }
            if (arrayOfVariables[i].getMin() < 0.0) {
                areNegatives = true;
            }
            if (maxPositiveValue < (prod = Math.abs(arrayOfValues[i] * arrayOfVariables[i].getMax()))) {
                maxPositiveValue = prod;
            }
            positiveMin += arrayOfVariables[i].getMin() * arrayOfValues[i];
            positiveMax += arrayOfVariables[i].getMax() * arrayOfValues[i];
        }
        double min = positiveMin;
        double max = positiveMax;
        if (areNegatives) {
            max = maxPositiveValue * (double)arrayOfVariables.length;
            min = -max;
        }
        for (int i = 0; i < arrayOfVariables.length; ++i) {
            coefPlus1[i] = arrayOfValues[i];
            varsPlus1[i] = arrayOfVariables[i];
        }
        coefPlus1[arrayOfValues.length] = -1.0;
        int n = this.getConstraints().length;
        ++this.numberOfScalProducts;
        varsPlus1[arrayOfVariables.length] = derivedVar = this.createVariableReal("_ScalProd" + this.numberOfScalProducts, min, max);
        Constraint c = (Constraint)this.post(coefPlus1, varsPlus1, "=", 0.0);
        c.setDerivedVar((ConstrainedVariable)((AbstractConstrainedVariable)derivedVar));
        return derivedVar;
    }

    public VarReal scalProd(double[] arrayOfValues, ConstrainedVariable[] arrayOfVariables) {
        if (arrayOfValues.length != arrayOfVariables.length) {
            throw new RuntimeException("Arrays of coefficients and vars should have the same length");
        }
        double[] coefPlus1 = new double[arrayOfValues.length + 1];
        ConstrainedVariable[] varsPlus1 = new ConstrainedVariable[arrayOfVariables.length + 1];
        for (int i = 0; i < arrayOfVariables.length; ++i) {
            coefPlus1[i] = arrayOfValues[i];
            varsPlus1[i] = arrayOfVariables[i];
        }
        coefPlus1[arrayOfValues.length] = -1.0;
        int n = this.getConstraints().length;
        ++this.numberOfScalProducts;
        VarReal derivedVar = this.createVariableReal("_ScalProd" + this.numberOfScalProducts);
        varsPlus1[arrayOfVariables.length] = derivedVar;
        Constraint c = (Constraint)this.post(coefPlus1, varsPlus1, "=", 0.0);
        c.setDerivedVar((ConstrainedVariable)((AbstractConstrainedVariable)derivedVar));
        return derivedVar;
    }

    public Var sum(Var[] vars) {
        if (vars.length == 0) {
            this.log("Attempt to find a sum of an empty array");
            return this.variable(0, 0);
        }
        int min = 0;
        int max = 0;
        for (int i = 0; i < vars.length; ++i) {
            min += vars[i].getMin();
            max += vars[i].getMax();
        }
        AbstractProblem p = (AbstractProblem)vars[0].getProblem();
        Var sumVar = p.variable("_sum_", min, max);
        p.post(vars, "=", sumVar);
        int[] coefficients = new int[vars.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = 1;
        }
        this.postScalProd(sumVar, "=", coefficients, vars);
        p.remove("_sum_");
        return sumVar;
    }

    public Var sum(String name, Var[] vars) {
        if (vars.length == 0) {
            this.log("Attempt to find a sum of an empty array");
            return this.variable(0, 0);
        }
        int min = 0;
        int max = 0;
        for (int i = 0; i < vars.length; ++i) {
            min += vars[i].getMin();
            max += vars[i].getMax();
        }
        AbstractProblem p = (AbstractProblem)vars[0].getProblem();
        Var sumVar = p.variable(name, min, max);
        int[] coefficients = new int[vars.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = 1;
        }
        this.postScalProd(sumVar, "=", coefficients, vars);
        return sumVar;
    }

    public VarReal sum(VarReal[] vars) {
        double[] coefficients = new double[vars.length];
        for (int i = 0; i < coefficients.length; ++i) {
            coefficients[i] = 1.0;
        }
        return this.scalProd(coefficients, vars);
    }

    public boolean isDerivedVar(AbstractConstrainedVariable var) {
        javax.constraints.Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Constraint c = (Constraint)constraints[i];
            if (var != c.getDerivedVar()) continue;
            return true;
        }
        return false;
    }

    public Constraint[] constraintsWithDerivedVars() {
        Vector<Constraint> vector = new Vector<Constraint>();
        javax.constraints.Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Constraint c = (Constraint)constraints[i];
            if (c.getDerivedVar() == null) continue;
            vector.add(c);
        }
        if (vector.isEmpty()) {
            return null;
        }
        Constraint[] result = new Constraint[vector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (Constraint)((Object)vector.get(i));
        }
        return result;
    }

    public Constraint findConstraintForVariable(String name) {
        javax.constraints.Constraint[] constraints = this.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            Constraint c = (Constraint)constraints[i];
            if (c.getDerivedVar() == null || !name.equals(c.getDerivedVar().getName())) continue;
            return c;
        }
        return null;
    }

    public javax.constraints.Constraint allDiff(Var[] vars) {
        throw new NonLinearProblemException("allDiff(Var[] vars)");
    }

    public javax.constraints.Constraint postCardinality(Var[] vars, int cardValue, String oper, int value) {
        throw new NonLinearProblemException("postCardinality(Var[] vars, int cardValue, String oper, int value)");
    }

    public javax.constraints.Constraint postCardinality(Var[] vars, int cardValue, String oper, Var var) {
        throw new NonLinearProblemException("postCardinality(Var[] vars, int cardValue, String oper, Var var)");
    }

    public String getImplVersion() {
        return JSR331_LINEAR_VERSION;
    }

    public Var createVariable(String name, int min, int max) {
        javax.constraints.impl.Var var = new javax.constraints.impl.Var((javax.constraints.Problem)this, name);
        var.setMin(min);
        var.setMax(max);
        return var;
    }

    public Var createVariable(String name) {
        javax.constraints.impl.Var var = new javax.constraints.impl.Var((javax.constraints.Problem)this, name);
        return var;
    }

    public VarReal createVariableReal(String name, double min, double max) {
        javax.constraints.impl.VarReal var = new javax.constraints.impl.VarReal((javax.constraints.Problem)this, name);
        var.setMin(min);
        var.setMax(max);
        this.add(name, var);
        return var;
    }

    public VarReal createVariableReal(String name) {
        javax.constraints.impl.VarReal var = new javax.constraints.impl.VarReal((javax.constraints.Problem)this, name);
        return var;
    }

    public VarBool variableBool(String name) {
        return (VarBool)this.variable(name, 0, 1);
    }

    public void post(javax.constraints.Constraint constraint) {
        this.add(constraint);
    }

    protected Solver createSolver() {
        LinearSolver solver = LinearSolverFactory.newLinearSolver(this);
        this.log("Solve problem using " + solver.getVersion());
        return solver;
    }

    public void log(String text) {
        logger.info(text);
    }

    public void debug(String text) {
        logger.debug(text);
    }

    public void error(String text) {
        logger.error(text);
    }

    public void loadFromXML(InputStream in) throws Exception {
        throw new RuntimeException("loadFromXML is not implemented");
    }

    public void storeToXML(OutputStream os, String comment) throws Exception {
        throw new RuntimeException("storeToXML is not implemented");
    }
}

