/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.Set;
import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.VarString;
import javax.constraints.impl.AbstractProblem;

public class Solution
implements javax.constraints.Solution {
    Solver solver;
    int solutionNumber;
    ResultInt[] intResults = null;
    ResultReal[] realResults = null;
    int varPerLine = 8;

    public Solution(Solver solver, int solutionNumber) {
        VarReal[] varReals;
        this.solver = solver;
        this.solutionNumber = solutionNumber;
        Var[] vars = this.getProblem().getVars();
        if (vars != null) {
            this.intResults = new ResultInt[vars.length];
            for (int i = 0; i < this.intResults.length; ++i) {
                this.intResults[i] = this.createResultInt(vars[i]);
            }
        }
        if ((varReals = this.getProblem().getVarReals()) != null) {
            this.realResults = new ResultReal[varReals.length];
            for (int i = 0; i < this.realResults.length; ++i) {
                this.realResults[i] = this.createResultReal(varReals[i]);
            }
        }
    }

    public Solver getSolver() {
        return this.solver;
    }

    public Problem getProblem() {
        return this.solver.getProblem();
    }

    public int getSolutionNumber() {
        return this.solutionNumber;
    }

    public void setSolutionNumber(int number) {
        this.solutionNumber = number;
    }

    public int getNumberOfVars() {
        if (this.intResults != null) {
            return this.intResults.length;
        }
        return 0;
    }

    public int getNumberOfVarReals() {
        if (this.realResults != null) {
            return this.realResults.length;
        }
        return 0;
    }

    public int getNumberOfVarSets() {
        return 0;
    }

    public int getValue(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].value;
    }

    public void setValue(String name, int value) {
        int i = this.getIndexOfInt(name);
        this.intResults[i].value = value;
    }

    public int getAt(String name) {
        return this.getValue(name);
    }

    public double getValueReal(String name) {
        int i = this.getIndexOfReal(name);
        return (this.realResults[i].min + this.realResults[i].max) / 2.0;
    }

    public void setValueReal(String name, double value) {
        int i = this.getIndexOfReal(name);
        this.realResults[i].value = value;
    }

    public Set<Integer> getValueSet(String name) {
        throw new RuntimeException("Linear solver does not deal with set variables");
    }

    public int getMin(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].min;
    }

    public int getMax(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].max;
    }

    public boolean isBound(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].bound;
    }

    private int getIndexOfInt(String name) {
        if (this.intResults != null) {
            for (int i = 0; i < this.intResults.length; ++i) {
                if (!name.equals(this.intResults[i].varName)) continue;
                return i;
            }
        }
        throw new RuntimeException("Integer variable " + name + " is not found in Solution");
    }

    private int getIndexOfReal(String name) {
        if (this.realResults != null) {
            for (int i = 0; i < this.realResults.length; ++i) {
                if (!name.equals(this.realResults[i].varName)) continue;
                return i;
            }
        }
        throw new RuntimeException("Real variable " + name + " is not found in Solution");
    }

    public boolean isBound() {
        for (int i = 0; i < this.intResults.length; ++i) {
            if (this.intResults[i].bound) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        if (this.intResults != null) {
            for (i = 0; i < this.intResults.length; ++i) {
                if (i > 0 && i % this.varPerLine == 0) {
                    buf.append("\n\t");
                }
                buf.append(" " + this.intResults[i].toString());
            }
        }
        if (this.realResults != null) {
            for (i = 0; i < this.realResults.length; ++i) {
                if (i > 0 && i % this.varPerLine == 0) {
                    buf.append("\n\t");
                }
                buf.append(" " + this.realResults[i].toString());
            }
        }
        return "Solution #" + this.solutionNumber + ":\n\t" + buf.toString();
    }

    public void log() {
        this.varPerLine = 9;
        this.getProblem().log(this.toString());
    }

    public void log(int varPerLinePar) {
        this.varPerLine = varPerLinePar;
        this.getProblem().log(this.toString());
    }

    public void logVars() {
        if (this.intResults != null) {
            for (int i = 0; i < this.intResults.length; ++i) {
                this.getProblem().log(this.intResults[i].toString());
            }
        }
    }

    public void logVarReals() {
        if (this.realResults != null) {
            for (int i = 0; i < this.realResults.length; ++i) {
                this.getProblem().log(this.realResults[i].toString());
            }
        }
    }

    ResultInt createResultInt(Var var) {
        ResultInt result = new ResultInt();
        result.varName = var.getName();
        if (var.isBound()) {
            result.min = result.value = var.getValue();
            result.max = result.value;
            result.bound = true;
        } else {
            result.min = var.getMin();
            result.max = var.getMax();
            result.bound = false;
        }
        return result;
    }

    ResultReal createResultReal(VarReal var) {
        ResultReal result = new ResultReal();
        result.varName = var.getName();
        if (var.isBound()) {
            result.min = result.value = var.getValue();
            result.max = result.value;
            result.bound = true;
        } else {
            result.min = var.getMin();
            result.max = var.getMax();
            result.bound = false;
        }
        return result;
    }

    public void save() {
        int i;
        if (this.intResults != null) {
            for (i = 0; i < this.intResults.length; ++i) {
                this.intResults[i].save();
            }
        }
        if (this.realResults != null) {
            for (i = 0; i < this.realResults.length; ++i) {
                this.realResults[i].save();
            }
        }
    }

    public String getValueString(String name) {
        int intValue = this.getValue(name);
        AbstractProblem p = (AbstractProblem)this.getProblem();
        VarString varString = p.getVarString(name);
        return varString.getValue(intValue);
    }

    class ResultReal {
        String varName;
        double value;
        double min;
        double max;
        boolean bound;

        ResultReal() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }

        public void save() {
            Problem p = Solution.this.getProblem();
            VarReal var = p.getVarReal(this.varName);
            if (var != null) {
                p.post(var, ">=", this.min);
                p.post(var, "<=", this.max);
            }
        }
    }

    class ResultInt {
        String varName;
        int value;
        int min;
        int max;
        boolean bound;

        ResultInt() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }

        public void save() {
            Problem p = Solution.this.getProblem();
            Var var = p.getVar(this.varName);
            if (var != null) {
                p.post(var, ">=", this.min);
                p.post(var, "<=", this.max);
            }
        }
    }
}

