/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.linear;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.HashMap;
import java.util.UUID;
import javax.constraints.Objective;
import javax.constraints.OptimizationStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.Problem;
import javax.constraints.linear.MpsGenerator;
import javax.constraints.linear.StreamGobbler;

public abstract class LinearSolver
extends javax.constraints.impl.search.Solver {
    public static String LP_SOLVER_EXE = "LP_SOLVER_EXE";
    public static String LP_SOLVER_OPTIONS = "LP_SOLVER_OPTIONS";
    public static String OUTPUT_FOLDER = "LP";
    private String correlationID = UUID.randomUUID().toString();

    public Solution findOptimalSolution(Objective objectiveDirection, Var objectiveVar) {
        File file = this.generateMpsFile(objectiveDirection, objectiveVar);
        int timeoutMilliSeconds = this.getTimeLimitGlobal();
        if (timeoutMilliSeconds > 0) {
            return this.solve(file, timeoutMilliSeconds);
        }
        return this.solve(file);
    }

    public Solution findOptimalSolution(Objective objectiveDirection, VarReal objectiveVar) {
        File file = this.generateMpsFile(objectiveDirection, objectiveVar);
        int timeoutMilliSeconds = this.getTimeLimitGlobal();
        if (timeoutMilliSeconds > 0) {
            return this.solve(file, timeoutMilliSeconds);
        }
        return this.solve(file);
    }

    public Solution findOptimalSolution(Objective objective, Var objectiveVar, OptimizationStrategy optStrategy) {
        this.setOptimizationStrategy(optStrategy);
        return this.findOptimalSolution(objective, objectiveVar);
    }

    public abstract Objective getDefaultOptimizationObjective();

    public File generateMpsFile(Objective objectiveDirection, Var objectiveVar) {
        Problem problem = (Problem)this.getProblem();
        problem.add(objectiveVar);
        return this.generateMpsFile(objectiveDirection, (AbstractConstrainedVariable)objectiveVar);
    }

    public File generateMpsFile(Objective objectiveDirection, VarReal objectiveVar) {
        Problem problem = (Problem)this.getProblem();
        problem.add(objectiveVar);
        return this.generateMpsFile(objectiveDirection, (AbstractConstrainedVariable)objectiveVar);
    }

    public File generateMpsFile(Objective objectiveDirection, AbstractConstrainedVariable objectiveVar) {
        Problem problem = (Problem)this.getProblem();
        int direction = 1;
        if (!objectiveDirection.equals((Object)this.getDefaultOptimizationObjective())) {
            direction = -1;
        }
        File file = new File(this.getInputFilename());
        MpsGenerator mpsGenerator = new MpsGenerator(problem, direction, objectiveVar, file);
        mpsGenerator.setIntegerVariablesOnly(true);
        mpsGenerator.generate();
        return file;
    }

    public String uniqueName(String ext) {
        File file = new File("./");
        File outFolder = new File(file, OUTPUT_FOLDER + "/");
        if (!outFolder.exists()) {
            outFolder.mkdirs();
        }
        return new File(outFolder, this.getProblem().getName() + "_" + this.correlationID + ext).getAbsolutePath();
    }

    public String getInputFilename() {
        return this.uniqueName(".mps");
    }

    public String getOutputFilename() {
        return this.uniqueName(".sol");
    }

    public String getLogFilename() {
        return this.uniqueName(".log");
    }

    protected String preProcess() {
        return null;
    }

    public Solution solve(File file) {
        return this.solve(file, -1);
    }

    public Solution solve(File file, int timeoutMilliSeconds) {
        String inputfile = this.preProcess();
        String command = this.getCommanLine();
        try {
            boolean result = StreamGobbler.execute(command, inputfile, this.getLogFilename(), timeoutMilliSeconds);
            if (!result) {
                return null;
            }
        }
        catch (Throwable t) {
            this.log("Cannot execute command: " + command);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        try {
            FileReader t = new FileReader(this.getOutputFilename());
        }
        catch (FileNotFoundException e1) {
            this.log("This solver cannot find a solution");
            return null;
        }
        HashMap<String, String> results = this.readResults();
        if (results != null) {
            Problem problem = (Problem)this.getProblem();
            String id = "";
            try {
                VarReal[] varReals;
                Var[] vars = problem.getVars();
                if (vars != null) {
                    for (int i = 0; i < vars.length; ++i) {
                        javax.constraints.impl.Var var = (javax.constraints.impl.Var)vars[i];
                        id = var.getId();
                        String stringValue = results.get(id);
                        if (stringValue != null) {
                            int value = (int)Double.parseDouble(stringValue);
                            var.setValue(value);
                            continue;
                        }
                        var.setValue(0);
                    }
                }
                if ((varReals = problem.getVarReals()) != null) {
                    for (int i = 0; i < varReals.length; ++i) {
                        javax.constraints.impl.VarReal varReal = (javax.constraints.impl.VarReal)varReals[i];
                        id = varReal.getId();
                        String stringValue = results.get(id);
                        if (stringValue != null) {
                            double value = Double.parseDouble(stringValue);
                            varReal.setValue(value);
                            continue;
                        }
                        varReal.setValue(0.0);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Unknown variable " + id + " while reading results in org.jcp.jsr331.linear";
                this.log(msg);
                throw new RuntimeException(msg);
            }
            javax.constraints.impl.search.Solution solution = new javax.constraints.impl.search.Solution((Solver)this, 1);
            return solution;
        }
        return null;
    }

    public int indexOfVariable(String name) {
        Problem problem = (Problem)this.getProblem();
        Var[] vars = problem.getVars();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                AbstractConstrainedVariable abstractConstrainedVariable = (AbstractConstrainedVariable)vars[i];
                if (!name.equals(abstractConstrainedVariable.getName())) continue;
                return i;
            }
        }
        return -1;
    }

    public abstract String getVersion();

    public abstract String getCommanLine();

    public abstract HashMap<String, String> readResults();

    public static String[] split(String line) {
        StringBuffer buf = new StringBuffer();
        line = line.trim();
        int nSpaces = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) {
                if (nSpaces > 0) continue;
                nSpaces = 1;
                buf.append(" ");
                continue;
            }
            buf.append(c);
            nSpaces = 0;
        }
        String result = buf.toString();
        return result.split(" ");
    }
}

